/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.jaxb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlMixed;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Message;
import org.apache.camel.converter.jaxb.HeaderType;
import org.apache.camel.converter.jaxb.IntegerHeader;
import org.apache.camel.converter.jaxb.LongHeader;
import org.apache.camel.converter.jaxb.StringHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="message")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class MessageType {
    @XmlElementRef(type=HeaderType.class)
    List<HeaderType> headers = new ArrayList<HeaderType>();
    @XmlAnyElement(lax=true)
    @XmlMixed
    private List content = new ArrayList();
    @XmlTransient
    private Object body;

    public Object getBody() {
        if (this.body == null && this.content != null) {
            if (this.content.size() == 1) {
                return this.content.get(0);
            }
            return this.content;
        }
        return this.body;
    }

    public void setBody(Object body) {
        this.body = body;
        if (body instanceof List) {
            this.content = (List)body;
        } else {
            this.content = new ArrayList();
            this.content.add(body);
        }
    }

    public List<HeaderType> getHeaders() {
        return this.headers;
    }

    public void setHeaders(List<HeaderType> headers) {
        this.headers = headers;
    }

    public Map<String, Object> getHeaderMap() {
        HashMap<String, Object> answer = new HashMap<String, Object>();
        for (HeaderType header : this.headers) {
            answer.put(header.getName(), header.getValue());
        }
        return answer;
    }

    public void copyFrom(Message message) {
        this.headers.clear();
        Set entries = message.getHeaders().entrySet();
        for (Map.Entry entry : entries) {
            Object value = entry.getValue();
            if (value == null) continue;
            this.headers.add(this.createHeader((String)entry.getKey(), value));
        }
        this.setBody(message.getBody());
    }

    public void copyTo(Message message) {
        message.setHeaders(this.getHeaderMap());
        message.setBody(this.getBody());
    }

    protected HeaderType createHeader(String key, Object value) {
        if (value instanceof String) {
            return new StringHeader(key, (String)value);
        }
        if (value instanceof Integer) {
            return new IntegerHeader(key, (Integer)value);
        }
        if (value instanceof Long) {
            return new LongHeader(key, (Long)value);
        }
        return new StringHeader(key, value.toString());
    }
}

