/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jacksonxml.converter;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.jacksonxml.converter.JacksonXMLTypeConverters;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;

@DeferredContextBinding
public final class JacksonXMLTypeConvertersLoader
implements TypeConverterLoader,
CamelContextAware {
    private CamelContext camelContext;
    private volatile JacksonXMLTypeConverters jacksonXMLTypeConverters;

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerFallbackConverters(registry);
    }

    private void registerFallbackConverters(TypeConverterRegistry registry) {
        JacksonXMLTypeConvertersLoader.addFallbackTypeConverter(registry, false, false, (type, exchange, value) -> this.getJacksonXMLTypeConverters().convertTo(type, exchange, value, registry));
    }

    private static void addFallbackTypeConverter(TypeConverterRegistry registry, boolean allowNull, boolean canPromote, SimpleTypeConverter.ConversionMethod method) {
        registry.addFallbackTypeConverter((TypeConverter)new SimpleTypeConverter(allowNull, method), canPromote);
    }

    private JacksonXMLTypeConverters getJacksonXMLTypeConverters() {
        if (this.jacksonXMLTypeConverters == null) {
            this.jacksonXMLTypeConverters = new JacksonXMLTypeConverters();
            CamelContextAware.trySetCamelContext((Object)this.jacksonXMLTypeConverters, (CamelContext)this.camelContext);
        }
        return this.jacksonXMLTypeConverters;
    }
}

