/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jackson.protobuf.transform;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.dataformat.protobuf.schema.ProtobufSchema;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.component.jackson.SchemaHelper;
import org.apache.camel.component.jackson.protobuf.transform.Protobuf;
import org.apache.camel.component.jackson.transform.Json;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeTransformer;
import org.apache.camel.spi.MimeType;
import org.apache.camel.spi.Transformer;

@DataTypeTransformer(name="protobuf-x-struct", description="Transforms to generic JSonNode using Jackson Protobuf (supports content schema)")
public class ProtobufStructDataTypeTransformer
extends Transformer {
    public void transform(Message message, DataType fromType, DataType toType) {
        ProtobufSchema schema = (ProtobufSchema)message.getExchange().getProperty("X-Content-Schema", ProtobufSchema.class);
        if (schema == null) {
            throw new CamelExecutionException("Missing proper Protobuf schema for data type processing", message.getExchange());
        }
        try {
            Object unmarshalled;
            String contentClass = SchemaHelper.resolveContentClass((Exchange)message.getExchange(), null);
            if (contentClass != null) {
                Class contentType = message.getExchange().getContext().getClassResolver().resolveMandatoryClass(contentClass);
                unmarshalled = Protobuf.mapper().reader().forType(JsonNode.class).with((FormatSchema)schema).readValue(Protobuf.mapper().writerFor(contentType).with((FormatSchema)schema).writeValueAsBytes(message.getBody()));
            } else {
                String jsonString;
                Object object = message.getBody();
                unmarshalled = object instanceof String && Json.isJson((String)(jsonString = (String)object)) ? Json.mapper().readTree(this.getBodyAsStream(message)) : Protobuf.mapper().reader().forType(JsonNode.class).with((FormatSchema)schema).readValue(this.getBodyAsStream(message));
            }
            message.setBody(unmarshalled);
            message.setHeader("Content-Type", (Object)MimeType.STRUCT.type());
        }
        catch (IOException | ClassNotFoundException | InvalidPayloadException e) {
            throw new CamelExecutionException("Failed to apply Protobuf x-struct data type on exchange", message.getExchange(), e);
        }
    }

    private InputStream getBodyAsStream(Message message) throws InvalidPayloadException {
        InputStream bodyStream = (InputStream)message.getBody(InputStream.class);
        if (bodyStream == null) {
            bodyStream = new ByteArrayInputStream((byte[])message.getMandatoryBody(byte[].class));
        }
        return bodyStream;
    }
}

