/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.iso8583;

import com.solab.iso8583.IsoMessage;
import com.solab.iso8583.MessageFactory;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.service.ServiceSupport;

@Dataformat(value="iso8583")
@Metadata(firstVersion="4.14.0", title="ISO-8583")
public class Iso8583DataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName,
CamelContextAware {
    private CamelContext camelContext;
    private MessageFactory messageFactory;
    private String configFile;
    private boolean allowAutoWiredMessageFormat = true;
    private String isoType;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String getDataFormatName() {
        return "iso8583";
    }

    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        IsoMessage iso = (IsoMessage)exchange.getContext().getTypeConverter().mandatoryConvertTo(IsoMessage.class, exchange, graph);
        byte[] data = iso.writeData();
        if (data != null && data.length > 0) {
            stream.write(data);
        }
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        byte[] data = (byte[])this.camelContext.getTypeConverter().mandatoryConvertTo(byte[].class, exchange, (Object)stream);
        int len = -1;
        String iType = (String)exchange.getMessage().getHeader("CamelIso8583IsoType", (Object)this.isoType, String.class);
        int i = Integer.parseUnsignedInt(iType, 16);
        String type = this.messageFactory.getIsoHeader(i);
        if (type != null) {
            len = type.length();
        }
        if (len == -1) {
            throw new IllegalArgumentException("IsoType " + iType + " is not known in the MessageFactory configuration file.");
        }
        return this.messageFactory.parseMessage(data, len);
    }

    public MessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    public void setMessageFactory(MessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public String getIsoType() {
        return this.isoType;
    }

    public void setIsoType(String isoType) {
        this.isoType = isoType;
    }

    protected void doInit() throws Exception {
        super.doInit();
        if (this.messageFactory == null) {
            if (this.allowAutoWiredMessageFormat) {
                this.messageFactory = (MessageFactory)CamelContextHelper.findSingleByType((CamelContext)this.camelContext, MessageFactory.class);
            }
            if (this.messageFactory == null) {
                this.messageFactory = new MessageFactory();
                if (this.configFile == null) {
                    this.configFile = "j8583-config.xml";
                }
            }
            if (this.configFile != null) {
                this.messageFactory.setConfigPath(this.configFile);
            }
        }
    }
}

