/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ironmq;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.ironmq.IronMQConfiguration;
import org.apache.camel.component.ironmq.IronMQEndpoint;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.HealthCheckComponent;

@Component(value="ironmq")
public class IronMQComponent
extends HealthCheckComponent {
    public IronMQComponent(CamelContext context) {
        super(context);
    }

    public IronMQComponent() {
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (remaining == null || remaining.isBlank()) {
            throw new IllegalArgumentException("Queue name must be specified.");
        }
        IronMQConfiguration ironMQConfiguration = new IronMQConfiguration();
        IronMQEndpoint endpoint = new IronMQEndpoint(uri, this, ironMQConfiguration);
        ironMQConfiguration.setQueueName(remaining);
        this.setProperties((Endpoint)endpoint, parameters);
        if (ironMQConfiguration.getClient() == null && (ironMQConfiguration.getProjectId() == null || ironMQConfiguration.getToken() == null)) {
            throw new IllegalArgumentException("Client or project and token must be specified.");
        }
        return endpoint;
    }
}

