/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.irc;

import org.schwering.irc.lib.IRCEventAdapter;
import org.schwering.irc.lib.IRCModeParser;
import org.schwering.irc.lib.IRCUser;
import org.slf4j.Logger;

public class IrcLogger
extends IRCEventAdapter {
    private Logger log;
    private String server;

    public IrcLogger(Logger log, String server) {
        this.log = log;
        this.server = server;
    }

    public void onDisconnected() {
        this.log.info("Server: {} - onDisconnected", (Object)this.server);
    }

    public void onError(int num, String msg) {
        this.log.error("Server: {} - onError num={} msg=\"{}\"", new Object[]{this.server, num, msg});
    }

    public void onError(String msg) {
        this.log.error("Server: {} - onError msg=\"{}\"", (Object)this.server, (Object)msg);
    }

    public void onInvite(String chan, IRCUser user, String passiveNick) {
        this.log.debug("Server: {} - onInvite chan={} user={} passiveNick={}", new Object[]{this.server, chan, user, passiveNick});
    }

    public void onJoin(String chan, IRCUser user) {
        this.log.debug("Server: {} - onJoin chan={} user={}", new Object[]{this.server, chan, user});
    }

    public void onKick(String chan, IRCUser user, String passiveNick, String msg) {
        this.log.debug("Server: {} - onKick chan={} user={} passiveNick={} msg=\"{}\"", new Object[]{this.server, chan, user, passiveNick, msg});
    }

    public void onMode(String chan, IRCUser user, IRCModeParser ircModeParser) {
        this.log.info("Server: {} - onMode chan={} user={} ircModeParser={}", new Object[]{this.server, chan, user, ircModeParser});
    }

    public void onMode(IRCUser user, String passiveNick, String mode) {
        this.log.info("Server: {} - onMode user={} passiveNick={} mode={}", new Object[]{this.server, user, passiveNick, mode});
    }

    public void onNick(IRCUser user, String newNick) {
        this.log.debug("Server: {} - onNick user={} newNick={}", new Object[]{this.server, user, newNick});
    }

    public void onNotice(String target, IRCUser user, String msg) {
        this.log.debug("Server: {} - onNotice target={} user={} msg=\"{}\"", new Object[]{this.server, target, user, msg});
    }

    public void onPart(String chan, IRCUser user, String msg) {
        this.log.debug("Server: {} - onPart chan={} user={} msg=\"{}\"", new Object[]{this.server, chan, user, msg});
    }

    public void onPing(String ping) {
        this.log.info("Server: {} - onPing ping={}", (Object)this.server, (Object)ping);
    }

    public void onPrivmsg(String target, IRCUser user, String msg) {
        this.log.debug("Server: {} - onPrivmsg target={} user={} msg=\"{}\"", new Object[]{this.server, target, user, msg});
    }

    public void onQuit(IRCUser user, String msg) {
        this.log.debug("Server: {} - onQuit user={} msg=\"{}\"", new Object[]{this.server, user, msg});
    }

    public void onRegistered() {
        this.log.info("Server: {} - onRegistered", (Object)this.server);
    }

    public void onReply(int num, String value, String msg) {
        this.log.debug("Server: {} - onReply num={} value=\"{}\" msg=\"{}\"", new Object[]{this.server, num, value, msg});
    }

    public void onTopic(String chan, IRCUser user, String topic) {
        this.log.debug("Server: {} - onTopic chan={} user={} topic={}", new Object[]{this.server, chan, user, topic});
    }

    public void unknown(String prefix, String command, String middle, String trailing) {
        this.log.info("Server: {} - unknown prefix={} command={} middle={} trailing={}", new Object[]{this.server, prefix, command, middle, trailing});
    }
}

