/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.irc;

import org.apache.camel.Component;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.component.irc.IrcBinding;
import org.apache.camel.component.irc.IrcComponent;
import org.apache.camel.component.irc.IrcConfiguration;
import org.apache.camel.component.irc.IrcConsumer;
import org.apache.camel.component.irc.IrcExchange;
import org.apache.camel.component.irc.IrcMessage;
import org.apache.camel.component.irc.IrcProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.schwering.irc.lib.IRCModeParser;
import org.schwering.irc.lib.IRCUser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IrcEndpoint
extends DefaultEndpoint<IrcExchange> {
    private IrcBinding binding;
    private IrcConfiguration configuration;
    private IrcComponent component;

    public IrcEndpoint(String endpointUri, IrcComponent component, IrcConfiguration configuration) {
        super(endpointUri, (Component)component);
        this.component = component;
        this.configuration = configuration;
    }

    public boolean isSingleton() {
        return true;
    }

    public IrcExchange createExchange(ExchangePattern pattern) {
        return new IrcExchange(this.getContext(), pattern, this.getBinding());
    }

    public IrcExchange createOnPrivmsgExchange(String target, IRCUser user, String msg) {
        return new IrcExchange(this.getContext(), this.getExchangePattern(), this.getBinding(), new IrcMessage("PRIVMSG", target, user, msg));
    }

    public IrcExchange createOnNickExchange(IRCUser user, String newNick) {
        return new IrcExchange(this.getContext(), this.getExchangePattern(), this.getBinding(), new IrcMessage("NICK", user, newNick));
    }

    public IrcExchange createOnQuitExchange(IRCUser user, String msg) {
        return new IrcExchange(this.getContext(), this.getExchangePattern(), this.getBinding(), new IrcMessage("QUIT", user, msg));
    }

    public IrcExchange createOnJoinExchange(String channel, IRCUser user) {
        return new IrcExchange(this.getContext(), this.getExchangePattern(), this.getBinding(), new IrcMessage("JOIN", channel, user));
    }

    public IrcExchange createOnKickExchange(String channel, IRCUser user, String whoWasKickedNick, String msg) {
        return new IrcExchange(this.getContext(), this.getExchangePattern(), this.getBinding(), new IrcMessage("KICK", channel, user, whoWasKickedNick, msg));
    }

    public IrcExchange createOnModeExchange(String channel, IRCUser user, IRCModeParser modeParser) {
        return new IrcExchange(this.getContext(), this.getExchangePattern(), this.getBinding(), new IrcMessage("MODE", channel, user, modeParser.getLine()));
    }

    public IrcExchange createOnPartExchange(String channel, IRCUser user, String msg) {
        return new IrcExchange(this.getContext(), this.getExchangePattern(), this.getBinding(), new IrcMessage("PART", channel, user, msg));
    }

    public IrcExchange createOnTopicExchange(String channel, IRCUser user, String topic) {
        return new IrcExchange(this.getContext(), this.getExchangePattern(), this.getBinding(), new IrcMessage("TOPIC", channel, user, topic));
    }

    public IrcProducer createProducer() throws Exception {
        return new IrcProducer(this, this.component.getIRCConnection(this.configuration));
    }

    public IrcConsumer createConsumer(Processor processor) throws Exception {
        return new IrcConsumer(this, processor, this.component.getIRCConnection(this.configuration));
    }

    public IrcComponent getComponent() {
        return this.component;
    }

    public void setComponent(IrcComponent component) {
        this.component = component;
    }

    public IrcBinding getBinding() {
        if (this.binding == null) {
            this.binding = new IrcBinding();
        }
        return this.binding;
    }

    public void setBinding(IrcBinding binding) {
        this.binding = binding;
    }

    public IrcConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(IrcConfiguration configuration) {
        this.configuration = configuration;
    }
}

