/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan.remote;

import java.util.function.Supplier;
import org.apache.camel.Service;
import org.apache.camel.ShutdownableService;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.infinispan.InfinispanIdempotentRepository;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteConfiguration;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteManager;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteUtil;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.function.Suppliers;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.commons.api.BasicCache;

@Metadata(label="bean", description="Idempotent repository that uses remote Infinispan to store message ids.", annotations={"interfaceName=org.apache.camel.spi.IdempotentRepository"})
@Configurer(metadataOnly=true)
@ManagedResource(description="Infinispan Remote message id repository")
public class InfinispanRemoteIdempotentRepository
extends InfinispanIdempotentRepository {
    private Supplier<RemoteCache<String, Boolean>> cache;
    private InfinispanRemoteManager manager;
    @Metadata(description="Name of cache", required=true)
    private String cacheName;
    @Metadata(description="Configuration for remote Infinispan")
    private InfinispanRemoteConfiguration configuration;

    public InfinispanRemoteIdempotentRepository() {
    }

    public InfinispanRemoteIdempotentRepository(String cacheName) {
        this.cacheName = cacheName;
    }

    protected void doStart() throws Exception {
        super.doStart();
        ObjectHelper.notNull((Object)this.cacheName, (String)"cacheName", (Object)((Object)this));
        if (this.configuration == null) {
            this.configuration = new InfinispanRemoteConfiguration();
        }
        this.manager = new InfinispanRemoteManager(this.configuration);
        this.manager.setCamelContext(this.getCamelContext());
        this.cache = Suppliers.memorize(() -> InfinispanRemoteUtil.getCacheWithFlags(this.manager, this.cacheName, Flag.FORCE_RETURN_VALUE));
        ServiceHelper.startService((Service)this.manager);
    }

    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownService((ShutdownableService)this.manager);
        super.doShutdown();
    }

    protected BasicCache<String, Boolean> getCache() {
        return (BasicCache)this.cache.get();
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public InfinispanRemoteConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(InfinispanRemoteConfiguration configuration) {
        this.configuration = configuration;
    }

    public InfinispanRemoteManager getManager() {
        return this.manager;
    }

    public void setManager(InfinispanRemoteManager manager) {
        this.manager = manager;
    }

    public RemoteCacheManager getCacheContainer() {
        return this.configuration != null ? this.configuration.getCacheContainer() : null;
    }

    public void setCacheContainer(RemoteCacheManager cacheContainer) {
        if (this.configuration == null) {
            this.configuration = new InfinispanRemoteConfiguration();
        }
        this.configuration.setCacheContainer(cacheContainer);
    }
}

