/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.support.service.ServiceSupport;
import org.infinispan.commons.api.BasicCache;

public abstract class InfinispanIdempotentRepository
extends ServiceSupport
implements IdempotentRepository,
CamelContextAware {
    private CamelContext camelContext;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @ManagedOperation(description="Adds the key to the store")
    public boolean add(String key) {
        if (this.getCache().containsKey((Object)key)) {
            return false;
        }
        Boolean put = (Boolean)this.getCache().put((Object)key, (Object)true);
        return put == null;
    }

    @ManagedOperation(description="Does the store contain the given key")
    public boolean contains(String key) {
        return this.getCache().containsKey((Object)key);
    }

    @ManagedOperation(description="Remove the key from the store")
    public boolean remove(String key) {
        return this.getCache().remove((Object)key) != null;
    }

    @ManagedOperation(description="Clear the store")
    public void clear() {
        this.getCache().clear();
    }

    @ManagedAttribute(description="The processor name")
    public String getCacheName() {
        return this.getCache().getName();
    }

    public boolean confirm(String key) {
        return true;
    }

    protected abstract BasicCache<String, Boolean> getCache();
}

