/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ical;

import java.io.ByteArrayInputStream;
import java.time.Instant;
import java.util.Date;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.property.DateProperty;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.ical.ICalConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;

@DeferredContextBinding
public final class ICalConverterLoader
implements TypeConverterLoader,
CamelContextAware {
    private CamelContext camelContext;

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        ICalConverterLoader.addTypeConverter(registry, ByteArrayInputStream.class, Calendar.class, false, (type, exchange, value) -> {
            ByteArrayInputStream answer = ICalConverter.toStream((Calendar)value, exchange);
            return answer;
        });
        ICalConverterLoader.addTypeConverter(registry, Instant.class, DateProperty.class, true, (type, exchange, value) -> {
            Object answer = ICalConverter.toInstant((DateProperty)value);
            if (answer == null) {
                answer = Void.class;
            }
            return answer;
        });
        ICalConverterLoader.addTypeConverter(registry, Date.class, DateProperty.class, true, (type, exchange, value) -> {
            Object answer = ICalConverter.toDate((DateProperty)value);
            if (answer == null) {
                answer = Void.class;
            }
            return answer;
        });
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

