/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ibm.secrets.manager;

import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.IamAuthenticator;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.SecretsManager;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.ibm.secrets.manager.IBMSecretsManagerConfiguration;
import org.apache.camel.component.ibm.secrets.manager.IBMSecretsManagerConstants;
import org.apache.camel.component.ibm.secrets.manager.IBMSecretsManagerProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="4.11.0", scheme="ibm-secrets-manager", title="IBM Secrets Manager", syntax="ibm-secrets-manager:label", category={Category.CLOUD, Category.CLOUD}, producerOnly=true, headersClass=IBMSecretsManagerConstants.class)
public class IBMSecretsManagerEndpoint
extends DefaultEndpoint {
    private SecretsManager secretManager;
    @UriParam
    private IBMSecretsManagerConfiguration configuration;

    public IBMSecretsManagerEndpoint(String uri, Component component, IBMSecretsManagerConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public void doInit() throws Exception {
        super.doInit();
        this.secretManager = this.createSecretManager();
    }

    private SecretsManager createSecretManager() {
        IamAuthenticator iamAuthenticator = new IamAuthenticator.Builder().apikey(this.getConfiguration().getToken()).build();
        SecretsManager secretsManager = new SecretsManager("Camel Secrets Manager Service", (Authenticator)iamAuthenticator);
        secretsManager.setServiceUrl(this.getConfiguration().getServiceUrl());
        return secretsManager;
    }

    public Producer createProducer() throws Exception {
        return new IBMSecretsManagerProducer((Endpoint)this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer not supported");
    }

    public IBMSecretsManagerConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(IBMSecretsManagerConfiguration configuration) {
        this.configuration = configuration;
    }

    public SecretsManager getSecretManager() {
        return this.secretManager;
    }

    public void setSecretManager(SecretsManager secretManager) {
        this.secretManager = secretManager;
    }
}

