/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ibm.secrets.manager;

import com.ibm.cloud.sdk.core.http.Response;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.ArbitrarySecretPrototype;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.CreateSecretOptions;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.DeleteSecretOptions;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.GetSecretOptions;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.KVSecretPrototype;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.Secret;
import com.ibm.cloud.secrets_manager_sdk.secrets_manager.v2.model.SecretPrototype;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.ibm.secrets.manager.IBMSecretsManagerConfiguration;
import org.apache.camel.component.ibm.secrets.manager.IBMSecretsManagerEndpoint;
import org.apache.camel.component.ibm.secrets.manager.IBMSecretsManagerOperation;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;

public class IBMSecretsManagerProducer
extends DefaultProducer {
    public IBMSecretsManagerProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        IBMSecretsManagerOperation operation = this.determineOperation(exchange);
        switch (operation) {
            case createArbitrarySecret: {
                this.createArbitratySecret(exchange);
                break;
            }
            case createKVSecret: {
                this.createKVSecret(exchange);
                break;
            }
            case getSecret: {
                this.getSecret(exchange);
                break;
            }
            case deleteSecret: {
                this.deleteSecret(exchange);
                break;
            }
            case listSecrets: {
                this.listSecrets(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private void createArbitratySecret(Exchange exchange) {
        ArbitrarySecretPrototype.Builder arbitrarySecretResourceBuilder = new ArbitrarySecretPrototype.Builder();
        if (!ObjectHelper.isNotEmpty((String)((String)exchange.getMessage().getHeader("CamelIbmSecretsManagerSecretName", String.class)))) {
            throw new IllegalArgumentException("Secret Name must be specified");
        }
        arbitrarySecretResourceBuilder.name((String)exchange.getMessage().getHeader("CamelIbmSecretsManagerSecretName", String.class));
        arbitrarySecretResourceBuilder.payload((String)exchange.getMessage().getBody(String.class));
        arbitrarySecretResourceBuilder.secretType("arbitrary");
        ArbitrarySecretPrototype arbitrarySecretResource = arbitrarySecretResourceBuilder.build();
        CreateSecretOptions createSecretOptions = new CreateSecretOptions.Builder().secretPrototype((SecretPrototype)arbitrarySecretResource).build();
        Response createResp = this.getEndpoint().getSecretManager().createSecret(createSecretOptions).execute();
        exchange.getMessage().setBody((Object)((Secret)createResp.getResult()).getId());
    }

    private void createKVSecret(Exchange exchange) {
        KVSecretPrototype.Builder kvSecretResourceBuilder = new KVSecretPrototype.Builder();
        if (!ObjectHelper.isNotEmpty((String)((String)exchange.getMessage().getHeader("CamelIbmSecretsManagerSecretName", String.class)))) {
            throw new IllegalArgumentException("Secret Name must be specified");
        }
        kvSecretResourceBuilder.name((String)exchange.getMessage().getHeader("CamelIbmSecretsManagerSecretName", String.class));
        kvSecretResourceBuilder.data((Map)exchange.getMessage().getBody(Map.class));
        kvSecretResourceBuilder.secretType("kv");
        KVSecretPrototype kvSecretResource = kvSecretResourceBuilder.build();
        CreateSecretOptions createSecretOptions = new CreateSecretOptions.Builder().secretPrototype((SecretPrototype)kvSecretResource).build();
        Response createResp = this.getEndpoint().getSecretManager().createSecret(createSecretOptions).execute();
        exchange.getMessage().setBody((Object)((Secret)createResp.getResult()).getId());
    }

    private void getSecret(Exchange exchange) {
        String secretType;
        GetSecretOptions.Builder getSecretOptionsBuilder = new GetSecretOptions.Builder();
        if (!ObjectHelper.isNotEmpty((String)((String)exchange.getMessage().getHeader("CamelIbmSecretsManagerSecretId", String.class)))) {
            throw new IllegalArgumentException("Secret ID must be specified");
        }
        getSecretOptionsBuilder.id((String)exchange.getMessage().getHeader("CamelIbmSecretsManagerSecretId", String.class));
        Response getResp = this.getEndpoint().getSecretManager().getSecret(getSecretOptionsBuilder.build()).execute();
        switch (secretType = ((Secret)getResp.getResult()).getSecretType()) {
            case "arbitrary": {
                exchange.getMessage().setBody((Object)((Secret)getResp.getResult()).getPayload());
                break;
            }
            case "kv": {
                exchange.getMessage().setBody((Object)((Secret)getResp.getResult()).getData());
                break;
            }
            case "service_credentials": {
                exchange.getMessage().setBody(getResp.getResult());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported Secret Type");
            }
        }
    }

    private void deleteSecret(Exchange exchange) {
        DeleteSecretOptions.Builder deleteSecretOptionsBuilder = new DeleteSecretOptions.Builder();
        if (!ObjectHelper.isNotEmpty((String)((String)exchange.getMessage().getHeader("CamelIbmSecretsManagerSecretId", String.class)))) {
            throw new IllegalArgumentException("Secret ID must be specified");
        }
        deleteSecretOptionsBuilder.id((String)exchange.getMessage().getHeader("CamelIbmSecretsManagerSecretId", String.class));
        this.getEndpoint().getSecretManager().deleteSecret(deleteSecretOptionsBuilder.build()).execute();
    }

    private void listSecrets(Exchange exchange) {
        Response result = this.getEndpoint().getSecretManager().listSecrets().execute();
        exchange.getMessage().setBody(result.getResult());
    }

    public IBMSecretsManagerEndpoint getEndpoint() {
        return (IBMSecretsManagerEndpoint)super.getEndpoint();
    }

    public IBMSecretsManagerConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    private IBMSecretsManagerOperation determineOperation(Exchange exchange) {
        IBMSecretsManagerOperation operation = (IBMSecretsManagerOperation)((Object)exchange.getIn().getHeader("CamelIbmSecretsManagerProducerOperation", IBMSecretsManagerOperation.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation();
        }
        return operation;
    }
}

