/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.huaweicloud.iam;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.huaweicloud.sdk.iam.v3.IamClient;
import com.huaweicloud.sdk.iam.v3.model.KeystoneListGroupsRequest;
import com.huaweicloud.sdk.iam.v3.model.KeystoneListGroupsResponse;
import com.huaweicloud.sdk.iam.v3.model.KeystoneListUsersForGroupByAdminRequest;
import com.huaweicloud.sdk.iam.v3.model.KeystoneListUsersForGroupByAdminResponse;
import com.huaweicloud.sdk.iam.v3.model.KeystoneListUsersRequest;
import com.huaweicloud.sdk.iam.v3.model.KeystoneListUsersResponse;
import com.huaweicloud.sdk.iam.v3.model.KeystoneUpdateGroupOption;
import com.huaweicloud.sdk.iam.v3.model.KeystoneUpdateGroupRequest;
import com.huaweicloud.sdk.iam.v3.model.KeystoneUpdateGroupRequestBody;
import com.huaweicloud.sdk.iam.v3.model.KeystoneUpdateGroupResponse;
import com.huaweicloud.sdk.iam.v3.model.ShowUserRequest;
import com.huaweicloud.sdk.iam.v3.model.ShowUserResponse;
import com.huaweicloud.sdk.iam.v3.model.UpdateUserOption;
import com.huaweicloud.sdk.iam.v3.model.UpdateUserRequest;
import com.huaweicloud.sdk.iam.v3.model.UpdateUserRequestBody;
import com.huaweicloud.sdk.iam.v3.model.UpdateUserResponse;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.huaweicloud.iam.IAMEndpoint;
import org.apache.camel.component.huaweicloud.iam.models.ClientConfigurations;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IAMProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(IAMProducer.class);
    private IAMEndpoint endpoint;
    private IamClient iamClient;
    private Gson gson;

    public IAMProducer(IAMEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.gson = new Gson();
    }

    public void process(Exchange exchange) throws Exception {
        ClientConfigurations clientConfigurations = new ClientConfigurations();
        if (this.iamClient == null) {
            LOG.info("Initializing SDK client");
            this.iamClient = this.endpoint.initClient();
            LOG.info("IAM client initialized");
        }
        this.updateClientConfigs(exchange, clientConfigurations);
        switch (clientConfigurations.getOperation()) {
            case "listUsers": {
                this.listUsers(exchange);
                break;
            }
            case "getUser": {
                this.getUser(exchange, clientConfigurations);
                break;
            }
            case "updateUser": {
                this.updateUser(exchange, clientConfigurations);
                break;
            }
            case "listGroups": {
                this.listGroups(exchange);
                break;
            }
            case "getGroupUsers": {
                this.getGroupUsers(exchange, clientConfigurations);
                break;
            }
            case "updateGroup": {
                this.updateGroup(exchange, clientConfigurations);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("%s is not a supported operation", clientConfigurations.getOperation()));
            }
        }
    }

    private void listUsers(Exchange exchange) {
        KeystoneListUsersRequest request = new KeystoneListUsersRequest();
        KeystoneListUsersResponse response = this.iamClient.keystoneListUsers(request);
        exchange.getMessage().setBody((Object)this.gson.toJson((Object)response.getUsers()));
    }

    private void getUser(Exchange exchange, ClientConfigurations clientConfigurations) {
        if (ObjectHelper.isEmpty((String)clientConfigurations.getUserId())) {
            if (LOG.isErrorEnabled()) {
                LOG.error("No user id given");
            }
            throw new IllegalArgumentException("User id is mandatory to get user");
        }
        ShowUserRequest request = new ShowUserRequest().withUserId(clientConfigurations.getUserId());
        ShowUserResponse response = this.iamClient.showUser(request);
        exchange.getMessage().setBody((Object)this.gson.toJson((Object)response.getUser()));
    }

    private void updateUser(Exchange exchange, ClientConfigurations clientConfigurations) {
        UpdateUserOption userOption;
        Object body = exchange.getMessage().getBody();
        if (body instanceof UpdateUserOption) {
            userOption = (UpdateUserOption)body;
        } else if (body instanceof String) {
            String strBody = (String)body;
            try {
                userOption = (UpdateUserOption)new ObjectMapper().readValue(strBody, UpdateUserOption.class);
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException("String request body must be a valid JSON");
            }
        } else {
            throw new IllegalArgumentException("Exchange body is mandatory and should be a valid JSON string or UpdateUserOption object");
        }
        if (ObjectHelper.isEmpty((String)clientConfigurations.getUserId())) {
            if (LOG.isErrorEnabled()) {
                LOG.error("No user id given");
            }
            throw new IllegalArgumentException("User id is mandatory to update user");
        }
        UpdateUserRequestBody requestBody = new UpdateUserRequestBody().withUser(userOption);
        UpdateUserRequest request = new UpdateUserRequest().withBody(requestBody).withUserId(clientConfigurations.getUserId());
        UpdateUserResponse response = this.iamClient.updateUser(request);
        exchange.getMessage().setBody((Object)this.gson.toJson((Object)response.getUser()));
    }

    private void listGroups(Exchange exchange) {
        KeystoneListGroupsRequest request = new KeystoneListGroupsRequest();
        KeystoneListGroupsResponse response = this.iamClient.keystoneListGroups(request);
        exchange.getMessage().setBody((Object)this.gson.toJson((Object)response.getGroups()));
    }

    private void getGroupUsers(Exchange exchange, ClientConfigurations clientConfigurations) {
        if (ObjectHelper.isEmpty((String)clientConfigurations.getGroupId())) {
            if (LOG.isErrorEnabled()) {
                LOG.error("No group id given");
            }
            throw new IllegalArgumentException("Group id is mandatory to get group users");
        }
        KeystoneListUsersForGroupByAdminRequest request = new KeystoneListUsersForGroupByAdminRequest().withGroupId(clientConfigurations.getGroupId());
        KeystoneListUsersForGroupByAdminResponse response = this.iamClient.keystoneListUsersForGroupByAdmin(request);
        exchange.getMessage().setBody((Object)this.gson.toJson((Object)response.getUsers()));
    }

    private void updateGroup(Exchange exchange, ClientConfigurations clientConfigurations) {
        KeystoneUpdateGroupOption groupOption;
        Object body = exchange.getMessage().getBody();
        if (body instanceof KeystoneUpdateGroupOption) {
            groupOption = (KeystoneUpdateGroupOption)body;
        } else if (body instanceof String) {
            String strBody = (String)body;
            try {
                groupOption = (KeystoneUpdateGroupOption)new ObjectMapper().readValue(strBody, KeystoneUpdateGroupOption.class);
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException("String request body must be a valid JSON with the proper keys");
            }
        } else {
            throw new IllegalArgumentException("Exchange body is mandatory and should be a valid JSON string or KeystoneUpdateGroupOption object");
        }
        if (ObjectHelper.isEmpty((String)clientConfigurations.getGroupId())) {
            if (LOG.isErrorEnabled()) {
                LOG.error("No group id given");
            }
            throw new IllegalArgumentException("Group id is mandatory to update group");
        }
        KeystoneUpdateGroupRequestBody requestBody = new KeystoneUpdateGroupRequestBody().withGroup(groupOption);
        KeystoneUpdateGroupRequest request = new KeystoneUpdateGroupRequest().withBody(requestBody).withGroupId(clientConfigurations.getGroupId());
        KeystoneUpdateGroupResponse response = this.iamClient.keystoneUpdateGroup(request);
        exchange.getMessage().setBody((Object)this.gson.toJson((Object)response.getGroup()));
    }

    private void updateClientConfigs(Exchange exchange, ClientConfigurations clientConfigurations) {
        if (ObjectHelper.isEmpty((Object)exchange.getProperty("CamelHwCloudIamOperation")) && ObjectHelper.isEmpty((String)this.endpoint.getOperation())) {
            if (LOG.isErrorEnabled()) {
                LOG.error("No operation name given. Cannot proceed with IAM operations.");
            }
            throw new IllegalArgumentException("Operation name not found");
        }
        clientConfigurations.setOperation(ObjectHelper.isNotEmpty((Object)exchange.getProperty("CamelHwCloudIamOperation")) ? (String)exchange.getProperty("CamelHwCloudIamOperation") : this.endpoint.getOperation());
        if (ObjectHelper.isNotEmpty((Object)exchange.getProperty("CamelHwCloudIamUserId")) || ObjectHelper.isNotEmpty((String)this.endpoint.getUserId())) {
            clientConfigurations.setUserId(ObjectHelper.isNotEmpty((Object)exchange.getProperty("CamelHwCloudIamUserId")) ? (String)exchange.getProperty("CamelHwCloudIamUserId") : this.endpoint.getUserId());
        }
        if (ObjectHelper.isNotEmpty((Object)exchange.getProperty("CamelHwCloudIamGroupId")) || ObjectHelper.isNotEmpty((String)this.endpoint.getGroupId())) {
            clientConfigurations.setGroupId(ObjectHelper.isNotEmpty((Object)exchange.getProperty("CamelHwCloudIamGroupId")) ? (String)exchange.getProperty("CamelHwCloudIamGroupId") : this.endpoint.getGroupId());
        }
    }
}

