/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.huaweicloud.dms;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class DMSEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":operation";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "hwcloud-dms".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "operation", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(30);
        props.add("accessKey");
        props.add("accessUser");
        props.add("availableZones");
        props.add("endpoint");
        props.add("engine");
        props.add("engineVersion");
        props.add("ignoreSslVerification");
        props.add("instanceId");
        props.add("kafkaManagerPassword");
        props.add("kafkaManagerUser");
        props.add("lazyStartProducer");
        props.add("name");
        props.add("operation");
        props.add("partitionNum");
        props.add("password");
        props.add("productId");
        props.add("projectId");
        props.add("proxyHost");
        props.add("proxyPassword");
        props.add("proxyPort");
        props.add("proxyUser");
        props.add("region");
        props.add("secretKey");
        props.add("securityGroupId");
        props.add("serviceKeys");
        props.add("specification");
        props.add("storageSpace");
        props.add("storageSpecCode");
        props.add("subnetId");
        props.add("vpcId");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(5);
        secretProps.add("accessKey");
        secretProps.add("proxyPassword");
        secretProps.add("proxyUser");
        secretProps.add("secretKey");
        secretProps.add("serviceKeys");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
        MULTI_VALUE_PREFIXES = Collections.emptySet();
    }
}

