/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.huaweicloud.dms;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.huaweicloud.dms.DMSEndpoint;
import org.apache.camel.component.huaweicloud.dms.DmsClient;
import org.apache.camel.component.huaweicloud.dms.models.ClientConfigurations;
import org.apache.camel.component.huaweicloud.dms.models.CreateInstanceRequest;
import org.apache.camel.component.huaweicloud.dms.models.CreateInstanceRequestBody;
import org.apache.camel.component.huaweicloud.dms.models.CreateInstanceResponse;
import org.apache.camel.component.huaweicloud.dms.models.DeleteInstanceRequest;
import org.apache.camel.component.huaweicloud.dms.models.DmsInstance;
import org.apache.camel.component.huaweicloud.dms.models.ListInstancesRequest;
import org.apache.camel.component.huaweicloud.dms.models.ListInstancesResponse;
import org.apache.camel.component.huaweicloud.dms.models.QueryInstanceRequest;
import org.apache.camel.component.huaweicloud.dms.models.UpdateInstanceRequest;
import org.apache.camel.component.huaweicloud.dms.models.UpdateInstanceRequestBody;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMSProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(DMSProducer.class);
    private DMSEndpoint endpoint;
    private DmsClient dmsClient;
    private ObjectMapper mapper;

    public DMSProducer(DMSEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.mapper = new ObjectMapper();
    }

    public void process(Exchange exchange) throws Exception {
        ClientConfigurations clientConfigurations = new ClientConfigurations();
        if (this.dmsClient == null) {
            LOG.debug("Initializing SDK client");
            this.dmsClient = this.endpoint.initClient();
            LOG.debug("Successfully initialized SDK client");
        }
        this.updateClientConfigs(exchange, clientConfigurations);
        switch (clientConfigurations.getOperation()) {
            case "createInstance": {
                this.createInstance(exchange, clientConfigurations);
                break;
            }
            case "deleteInstance": {
                this.deleteInstance(exchange, clientConfigurations);
                break;
            }
            case "listInstances": {
                this.listInstances(exchange, clientConfigurations);
                break;
            }
            case "queryInstance": {
                this.queryInstance(exchange, clientConfigurations);
                break;
            }
            case "updateInstance": {
                this.updateInstance(exchange, clientConfigurations);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("%s is not a supported operation", clientConfigurations.getOperation()));
            }
        }
    }

    private void createInstance(Exchange exchange, ClientConfigurations clientConfigurations) throws JsonProcessingException {
        CreateInstanceRequestBody body = null;
        Object exchangeBody = exchange.getMessage().getBody();
        if (exchangeBody instanceof CreateInstanceRequestBody) {
            body = (CreateInstanceRequestBody)exchangeBody;
        } else if (exchangeBody instanceof String) {
            String strBody = (String)exchangeBody;
            try {
                body = (CreateInstanceRequestBody)this.mapper.readValue(strBody, CreateInstanceRequestBody.class);
            }
            catch (JsonProcessingException e) {
                LOG.warn("String request body must be a valid JSON representation of a CreateInstanceRequestBody. Attempting to create an instance from endpoint parameters");
            }
        }
        if (body == null) {
            if (ObjectHelper.isEmpty((String)clientConfigurations.getName())) {
                throw new IllegalArgumentException("Name is mandatory to create an instance");
            }
            if (ObjectHelper.isEmpty((String)clientConfigurations.getEngine())) {
                throw new IllegalArgumentException("Engine is mandatory to create an instance");
            }
            if (ObjectHelper.isEmpty((String)clientConfigurations.getEngineVersion())) {
                throw new IllegalArgumentException("Engine version is mandatory to create an instance");
            }
            if (clientConfigurations.getEngine().equals("kafka")) {
                if (ObjectHelper.isEmpty((String)clientConfigurations.getSpecification())) {
                    throw new IllegalArgumentException("Specification is mandatory to create a Kafka instance");
                }
                if (ObjectHelper.isEmpty((Object)clientConfigurations.getPartitionNum())) {
                    throw new IllegalArgumentException("Partition number is mandatory to create a Kafka instance");
                }
                if (ObjectHelper.isEmpty((String)clientConfigurations.getKafkaManagerUser())) {
                    throw new IllegalArgumentException("Kafka manager user is mandatory to create a Kafka instance");
                }
                if (ObjectHelper.isEmpty((String)clientConfigurations.getKafkaManagerPassword())) {
                    throw new IllegalArgumentException("Kafka manager password is mandatory to create a Kafka instance");
                }
            } else if (clientConfigurations.getEngine().equals("rabbitmq")) {
                if (ObjectHelper.isEmpty((String)clientConfigurations.getAccessUser())) {
                    throw new IllegalArgumentException("Access user is mandatory to create a RabbitMQ instance");
                }
                if (ObjectHelper.isEmpty((String)clientConfigurations.getPassword())) {
                    throw new IllegalArgumentException("Password is mandatory to create a RabbitMQ instance");
                }
            } else {
                throw new IllegalArgumentException("Engine must be 'kafka' or 'rabbitmq'");
            }
            if (ObjectHelper.isEmpty((Object)clientConfigurations.getStorageSpace())) {
                throw new IllegalArgumentException("Storage space is mandatory to create an instance");
            }
            if (ObjectHelper.isEmpty((String)clientConfigurations.getVpcId())) {
                throw new IllegalArgumentException("VPC ID is mandatory to create an instance");
            }
            if (ObjectHelper.isEmpty((String)clientConfigurations.getSecurityGroupId())) {
                throw new IllegalArgumentException("Security group ID is mandatory to create an instance");
            }
            if (ObjectHelper.isEmpty((String)clientConfigurations.getSubnetId())) {
                throw new IllegalArgumentException("Subnet ID is mandatory to create an instance");
            }
            if (ObjectHelper.isEmpty((String)clientConfigurations.getAvailableZones())) {
                throw new IllegalArgumentException("Available zones is mandatory to create an instance");
            }
            if (ObjectHelper.isEmpty((String)clientConfigurations.getProductId())) {
                throw new IllegalArgumentException("Product ID is mandatory to create an instance");
            }
            if (ObjectHelper.isEmpty((String)clientConfigurations.getStorageSpecCode())) {
                throw new IllegalArgumentException("Storage spec code is mandatory to create an instance");
            }
            body = new CreateInstanceRequestBody().withName(clientConfigurations.getName()).withEngine(clientConfigurations.getEngine()).withEngineVersion(clientConfigurations.getEngineVersion()).withSpecification(clientConfigurations.getSpecification()).withStorageSpace(clientConfigurations.getStorageSpace()).withPartitionNum(clientConfigurations.getPartitionNum()).withAccessUser(clientConfigurations.getAccessUser()).withPassword(clientConfigurations.getPassword()).withVpcId(clientConfigurations.getVpcId()).withSecurityGroupId(clientConfigurations.getSecurityGroupId()).withSubnetId(clientConfigurations.getSubnetId()).withAvailableZones((List)clientConfigurations.getAvailableZonesAsList()).withProductId(clientConfigurations.getProductId()).withKafkaManagerUser(clientConfigurations.getKafkaManagerUser()).withKafkaManagerPassword(clientConfigurations.getKafkaManagerPassword()).withStorageSpecCode(clientConfigurations.getStorageSpecCode());
        }
        CreateInstanceRequest request = new CreateInstanceRequest().withBody(body);
        CreateInstanceResponse response = this.dmsClient.createInstance(request);
        exchange.getMessage().setBody((Object)this.mapper.writeValueAsString((Object)response));
    }

    private void deleteInstance(Exchange exchange, ClientConfigurations clientConfigurations) {
        if (ObjectHelper.isEmpty((String)clientConfigurations.getInstanceId())) {
            throw new IllegalArgumentException("Instance id is mandatory to delete an instance");
        }
        DeleteInstanceRequest request = new DeleteInstanceRequest().withInstanceId(clientConfigurations.getInstanceId());
        this.dmsClient.deleteInstance(request);
        exchange.setProperty("CamelHwCloudDmsInstanceDeleted", (Object)true);
    }

    private void listInstances(Exchange exchange, ClientConfigurations clientConfigurations) throws JsonProcessingException {
        ListInstancesRequest request = new ListInstancesRequest().withEngine(clientConfigurations.getEngine());
        ListInstancesResponse response = this.dmsClient.listInstances(request);
        exchange.getMessage().setBody((Object)this.mapper.writeValueAsString(response.getInstances()));
    }

    private void queryInstance(Exchange exchange, ClientConfigurations clientConfigurations) throws JsonProcessingException {
        if (ObjectHelper.isEmpty((String)clientConfigurations.getInstanceId())) {
            throw new IllegalArgumentException("Instance id is mandatory to query an instance");
        }
        QueryInstanceRequest request = new QueryInstanceRequest().withInstanceId(clientConfigurations.getInstanceId());
        DmsInstance response = this.dmsClient.queryInstance(request);
        exchange.getMessage().setBody((Object)this.mapper.writeValueAsString((Object)response));
    }

    private void updateInstance(Exchange exchange, ClientConfigurations clientConfigurations) throws JsonProcessingException {
        UpdateInstanceRequestBody body;
        if (ObjectHelper.isEmpty((String)clientConfigurations.getInstanceId())) {
            throw new IllegalArgumentException("Instance id is mandatory to update an instance");
        }
        Object exchangeBody = exchange.getIn().getBody();
        if (exchangeBody instanceof UpdateInstanceRequestBody) {
            body = (UpdateInstanceRequestBody)exchangeBody;
        } else if (exchangeBody instanceof String) {
            String strBody = (String)exchangeBody;
            body = (UpdateInstanceRequestBody)this.mapper.readValue(strBody, UpdateInstanceRequestBody.class);
        } else {
            throw new IllegalArgumentException("Exchange body must include an UpdateInstanceRequestBody or a valid JSON String representation of it");
        }
        UpdateInstanceRequest request = new UpdateInstanceRequest().withInstanceId(clientConfigurations.getInstanceId()).withBody(body);
        this.dmsClient.updateInstance(request);
        exchange.setProperty("CamelHwCloudDmsInstanceUpdated", (Object)true);
    }

    private void updateClientConfigs(Exchange exchange, ClientConfigurations clientConfigurations) {
        if (ObjectHelper.isEmpty((Object)exchange.getProperty("CamelHwCloudDmsOperation")) && ObjectHelper.isEmpty((String)this.endpoint.getOperation())) {
            if (LOG.isErrorEnabled()) {
                LOG.error("No operation name given. Cannot proceed with DMS operations.");
            }
            throw new IllegalArgumentException("Operation name not found");
        }
        clientConfigurations.setOperation(ObjectHelper.isNotEmpty((Object)exchange.getProperty("CamelHwCloudDmsOperation")) ? (String)exchange.getProperty("CamelHwCloudDmsOperation") : this.endpoint.getOperation());
        clientConfigurations.setEngine(ObjectHelper.isNotEmpty((Object)exchange.getProperty("CamelHwCloudDmsEngine")) ? (String)exchange.getProperty("CamelHwCloudDmsEngine") : this.endpoint.getEngine());
        clientConfigurations.setInstanceId(ObjectHelper.isNotEmpty((Object)exchange.getProperty("CamelHwCloudDmsInstanceId")) ? (String)exchange.getProperty("CamelHwCloudDmsInstanceId") : this.endpoint.getInstanceId());
        clientConfigurations.setName(ObjectHelper.isNotEmpty((Object)exchange.getProperty("CamelHwCloudDmsName")) ? (String)exchange.getProperty("CamelHwCloudDmsName") : this.endpoint.getName());
        clientConfigurations.setEngineVersion(ObjectHelper.isNotEmpty((Object)exchange.getProperty("CamelHwCloudDmsEngineVersion")) ? (String)exchange.getProperty("CamelHwCloudDmsEngineVersion") : this.endpoint.getEngineVersion());
        clientConfigurations.setSpecification(ObjectHelper.isNotEmpty((Object)exchange.getProperty("CamelHwCloudDmsSpecification")) ? (String)exchange.getProperty("CamelHwCloudDmsSpecification") : this.endpoint.getSpecification());
        clientConfigurations.setStorageSpace(ObjectHelper.isNotEmpty((Object)exchange.getProperty("CamelHwCloudDmsStorageSpace")) ? ((Integer)exchange.getProperty("CamelHwCloudDmsStorageSpace")).intValue() : this.endpoint.getStorageSpace());
        clientConfigurations.setPartitionNum(ObjectHelper.isNotEmpty((Object)exchange.getProperty("CamelHwCloudDmsPartitionNum")) ? ((Integer)exchange.getProperty("CamelHwCloudDmsPartitionNum")).intValue() : this.endpoint.getPartitionNum());
        clientConfigurations.setAccessUser(ObjectHelper.isNotEmpty((Object)exchange.getProperty("CamelHwCloudDmsAccessUser")) ? (String)exchange.getProperty("CamelHwCloudDmsAccessUser") : this.endpoint.getAccessUser());
        clientConfigurations.setPassword(ObjectHelper.isNotEmpty((Object)exchange.getProperty("CamelHwCloudDmsPassword")) ? (String)exchange.getProperty("CamelHwCloudDmsPassword") : this.endpoint.getPassword());
        clientConfigurations.setVpcId(ObjectHelper.isNotEmpty((Object)exchange.getProperty("CamelHwCloudDmsVpcId")) ? (String)exchange.getProperty("CamelHwCloudDmsVpcId") : this.endpoint.getVpcId());
        clientConfigurations.setSecurityGroupId(ObjectHelper.isNotEmpty((Object)exchange.getProperty("CamelHwCloudDmsSecurityGroupId")) ? (String)exchange.getProperty("CamelHwCloudDmsSecurityGroupId") : this.endpoint.getSecurityGroupId());
        clientConfigurations.setSubnetId(ObjectHelper.isNotEmpty((Object)exchange.getProperty("CamelHwCloudDmsSubnetId")) ? (String)exchange.getProperty("CamelHwCloudDmsSubnetId") : this.endpoint.getSubnetId());
        clientConfigurations.setAvailableZones(ObjectHelper.isNotEmpty((Object)exchange.getProperty("CamelHwCloudDmsAvailableZones")) ? (String)exchange.getProperty("CamelHwCloudDmsAvailableZones", String.class) : this.endpoint.getAvailableZones());
        clientConfigurations.setProductId(ObjectHelper.isNotEmpty((Object)exchange.getProperty("CamelHwCloudDmsProductId")) ? (String)exchange.getProperty("CamelHwCloudDmsProductId") : this.endpoint.getProductId());
        clientConfigurations.setKafkaManagerUser(ObjectHelper.isNotEmpty((Object)exchange.getProperty("CamelHwCloudDmsKafkaManagerUser")) ? (String)exchange.getProperty("CamelHwCloudDmsKafkaManagerUser") : this.endpoint.getKafkaManagerUser());
        clientConfigurations.setKafkaManagerPassword(ObjectHelper.isNotEmpty((Object)exchange.getProperty("CamelHwCloudDmsKafkaManagerPassword")) ? (String)exchange.getProperty("CamelHwCloudDmsKafkaManagerPassword") : this.endpoint.getKafkaManagerPassword());
        clientConfigurations.setStorageSpecCode(ObjectHelper.isNotEmpty((Object)exchange.getProperty("CamelHwCloudDmsStorageSpecCode")) ? (String)exchange.getProperty("CamelHwCloudDmsStorageSpecCode") : this.endpoint.getStorageSpecCode());
    }
}

