/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.huaweicloud.dms;

import com.huaweicloud.sdk.core.auth.BasicCredentials;
import com.huaweicloud.sdk.core.auth.ICredential;
import com.huaweicloud.sdk.core.http.HttpConfig;
import java.util.Collection;
import java.util.List;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.huaweicloud.common.models.ServiceKeys;
import org.apache.camel.component.huaweicloud.dms.DMSComponent;
import org.apache.camel.component.huaweicloud.dms.DMSProducer;
import org.apache.camel.component.huaweicloud.dms.DmsClient;
import org.apache.camel.component.huaweicloud.dms.models.DmsRegion;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="3.12.0", scheme="hwcloud-dms", title="Huawei Distributed Message Service (DMS)", syntax="hwcloud-dms:operation", category={Category.CLOUD}, producerOnly=true)
public class DMSEndpoint
extends DefaultEndpoint {
    @UriPath(description="Operation to be performed", displayName="Operation", label="producer")
    @Metadata(required=true)
    private String operation;
    @UriParam(description="DMS service region", displayName="Service region")
    @Metadata(required=true)
    private String region;
    @UriParam(description="DMS url. Carries higher precedence than region parameter based client initialization", displayName="Service endpoint", secret=false)
    @Metadata(required=false)
    private String endpoint;
    @UriParam(description="Cloud project ID", displayName="Project ID")
    @Metadata(required=true)
    private String projectId;
    @UriParam(description="Proxy server ip/hostname", displayName="Proxy server host")
    @Metadata(required=false)
    private String proxyHost;
    @UriParam(description="Proxy server port", displayName="Proxy server port")
    @Metadata(required=false)
    private int proxyPort;
    @UriParam(description="Proxy authentication user", displayName="Proxy user", secret=true)
    @Metadata(required=false)
    private String proxyUser;
    @UriParam(description="Proxy authentication password", displayName="Proxy password", secret=true)
    @Metadata(required=false)
    private String proxyPassword;
    @UriParam(description="Ignore SSL verification", displayName="SSL Verification Ignored", defaultValue="false")
    @Metadata(required=false)
    private boolean ignoreSslVerification;
    @UriParam(description="Configuration object for cloud service authentication", displayName="Service Configuration", secret=true)
    @Metadata(required=false)
    private ServiceKeys serviceKeys;
    @UriParam(description="Access key for the cloud user", displayName="API access key (AK)", secret=true)
    @Metadata(required=true)
    private String accessKey;
    @UriParam(description="Secret key for the cloud user", displayName="API secret key (SK)", secret=true)
    @Metadata(required=true)
    private String secretKey;
    @UriParam(description="The message engine. Either kafka or rabbitmq. If the parameter is not specified, all instances will be queried", displayName="Engine type", enums="kafka,rabbitmq")
    @Metadata(required=false)
    private String engine;
    @UriParam(description="The id of the instance. This option is mandatory when deleting or querying an instance", displayName="Instance id")
    @Metadata(required=false)
    private String instanceId;
    @UriParam(description="The name of the instance for creating and updating an instance. This option is mandatory when creating an instance", displayName="Name")
    @Metadata(required=false)
    private String name;
    @UriParam(description="The version of the message engine. This option is mandatory when creating an instance.", displayName="Engine version")
    @Metadata(required=false)
    private String engineVersion;
    @UriParam(description="The baseline bandwidth of a Kafka instance. This option is mandatory when creating a Kafka instance.", displayName="Engine version")
    @Metadata(required=false)
    private String specification;
    @UriParam(description="The message storage space. This option is mandatory when creating an instance.", displayName="Storage space")
    @Metadata(required=false)
    private int storageSpace;
    @UriParam(description="The maximum number of partitions in a Kafka instance. This option is mandatory when creating a Kafka instance.", displayName="Partition Number")
    @Metadata(required=false)
    private int partitionNum;
    @UriParam(description="The username of a RabbitMQ instance. This option is mandatory when creating a RabbitMQ instance.", displayName="Access user")
    @Metadata(required=false)
    private String accessUser;
    @UriParam(description="The password of a RabbitMQ instance. This option is mandatory when creating a RabbitMQ instance.", displayName="Password")
    @Metadata(required=false)
    private String password;
    @UriParam(description="The VPC ID. This option is mandatory when creating an instance.", displayName="VPC ID")
    @Metadata(required=false)
    private String vpcId;
    @UriParam(description="The security group which the instance belongs to. This option is mandatory when creating an instance.", displayName="Security group ID")
    @Metadata(required=false)
    private String securityGroupId;
    @UriParam(description="The subnet ID. This option is mandatory when creating an instance.", displayName="Subnet ID")
    @Metadata(required=false)
    private String subnetId;
    @UriParam(description="A comma separated String of Availability Zones. This option is mandatory when creating an instance and it cannot be an empty array.", displayName="Available zones")
    @Metadata(required=false)
    private String availableZones;
    @UriParam(description="The product ID. This option is mandatory when creating an instance.", displayName="Product ID")
    @Metadata(required=false)
    private String productId;
    @UriParam(description="The username for logging in to the Kafka Manager. This option is mandatory when creating a Kafka instance.", displayName="Kafka manager username")
    @Metadata(required=false)
    private String kafkaManagerUser;
    @UriParam(description="The password for logging in to the Kafka Manager. This option is mandatory when creating a Kafka instance.", displayName="Kafka manager password")
    @Metadata(required=false)
    private String kafkaManagerPassword;
    @UriParam(description="The storage I/O specification. This option is mandatory when creating an instance.", displayName="Storage specification code")
    @Metadata(required=false)
    private String storageSpecCode;
    private DmsClient dmsClient;

    public DMSEndpoint() {
    }

    public DMSEndpoint(String uri, String operation, DMSComponent component) {
        super(uri, (Component)component);
        this.operation = operation;
    }

    public Producer createProducer() throws Exception {
        return new DMSProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public boolean isIgnoreSslVerification() {
        return this.ignoreSslVerification;
    }

    public void setIgnoreSslVerification(boolean ignoreSslVerification) {
        this.ignoreSslVerification = ignoreSslVerification;
    }

    public ServiceKeys getServiceKeys() {
        return this.serviceKeys;
    }

    public void setServiceKeys(ServiceKeys serviceKeys) {
        this.serviceKeys = serviceKeys;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getEngine() {
        return this.engine;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    public String getSpecification() {
        return this.specification;
    }

    public void setSpecification(String specification) {
        this.specification = specification;
    }

    public int getStorageSpace() {
        return this.storageSpace;
    }

    public void setStorageSpace(int storageSpace) {
        this.storageSpace = storageSpace;
    }

    public int getPartitionNum() {
        return this.partitionNum;
    }

    public void setPartitionNum(int partitionNum) {
        this.partitionNum = partitionNum;
    }

    public String getAccessUser() {
        return this.accessUser;
    }

    public void setAccessUser(String accessUser) {
        this.accessUser = accessUser;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public String getSecurityGroupId() {
        return this.securityGroupId;
    }

    public void setSecurityGroupId(String securityGroupId) {
        this.securityGroupId = securityGroupId;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public void setSubnetId(String subnetId) {
        this.subnetId = subnetId;
    }

    public String getAvailableZones() {
        return this.availableZones;
    }

    public Collection<String> getAvailableZonesAsList() {
        if (this.availableZones != null) {
            return List.of(this.availableZones.split(","));
        }
        return null;
    }

    public void setAvailableZones(String availableZones) {
        this.availableZones = availableZones;
    }

    public String getProductId() {
        return this.productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public String getKafkaManagerUser() {
        return this.kafkaManagerUser;
    }

    public void setKafkaManagerUser(String kafkaManagerUser) {
        this.kafkaManagerUser = kafkaManagerUser;
    }

    public String getKafkaManagerPassword() {
        return this.kafkaManagerPassword;
    }

    public void setKafkaManagerPassword(String kafkaManagerPassword) {
        this.kafkaManagerPassword = kafkaManagerPassword;
    }

    public String getStorageSpecCode() {
        return this.storageSpecCode;
    }

    public void setStorageSpecCode(String storageSpecCode) {
        this.storageSpecCode = storageSpecCode;
    }

    public DmsClient getDmsClient() {
        return this.dmsClient;
    }

    public void setDmsClient(DmsClient dmsClient) {
        this.dmsClient = dmsClient;
    }

    public DmsClient initClient() {
        if (this.dmsClient != null) {
            return this.dmsClient;
        }
        if (ObjectHelper.isEmpty((Object)this.getServiceKeys()) && ObjectHelper.isEmpty((String)this.getAccessKey())) {
            throw new IllegalArgumentException("Authentication parameter 'access key (AK)' not found");
        }
        if (ObjectHelper.isEmpty((Object)this.getServiceKeys()) && ObjectHelper.isEmpty((String)this.getSecretKey())) {
            throw new IllegalArgumentException("Authentication parameter 'secret key (SK)' not found");
        }
        BasicCredentials auth = ((BasicCredentials)((BasicCredentials)new BasicCredentials().withAk(this.getServiceKeys() != null ? this.getServiceKeys().getAccessKey() : this.getAccessKey())).withSk(this.getServiceKeys() != null ? this.getServiceKeys().getSecretKey() : this.getSecretKey())).withProjectId(this.getProjectId());
        HttpConfig httpConfig = HttpConfig.getDefaultHttpConfig();
        httpConfig.withIgnoreSSLVerification(this.isIgnoreSslVerification());
        if (ObjectHelper.isNotEmpty((String)this.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.getProxyPort())) {
            httpConfig.withProxyHost(this.getProxyHost()).withProxyPort(this.getProxyPort());
            if (ObjectHelper.isNotEmpty((String)this.getProxyUser())) {
                httpConfig.withProxyUsername(this.getProxyUser());
                if (ObjectHelper.isNotEmpty((String)this.getProxyPassword())) {
                    httpConfig.withProxyPassword(this.getProxyPassword());
                }
            }
        }
        if (ObjectHelper.isNotEmpty((String)this.getEndpoint())) {
            return (DmsClient)DmsClient.newBuilder().withCredential((ICredential)auth).withHttpConfig(httpConfig).withEndpoint(this.getEndpoint()).build();
        }
        return (DmsClient)DmsClient.newBuilder().withCredential((ICredential)auth).withHttpConfig(httpConfig).withRegion(DmsRegion.valueOf(this.getRegion())).build();
    }
}

