/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.GZIPHelper;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.InputStreamEntity;

@Converter(generateLoader=true)
public final class HttpEntityConverter {
    private HttpEntityConverter() {
    }

    @Converter
    public static HttpEntity toHttpEntity(byte[] data, Exchange exchange) throws Exception {
        return HttpEntityConverter.asHttpEntity(data, exchange);
    }

    @Converter
    public static HttpEntity toHttpEntity(InputStream inStream, Exchange exchange) throws Exception {
        return HttpEntityConverter.asHttpEntity(inStream, exchange);
    }

    @Converter
    public static HttpEntity toHttpEntity(String str, Exchange exchange) throws Exception {
        if (exchange != null && GZIPHelper.isGzip((Message)exchange.getIn())) {
            byte[] data = (byte[])exchange.getContext().getTypeConverter().convertTo(byte[].class, (Object)str);
            return HttpEntityConverter.asHttpEntity(data, exchange);
        }
        return null;
    }

    private static HttpEntity asHttpEntity(InputStream in, Exchange exchange) throws IOException {
        InputStreamEntity entity;
        String contentEncoding = null;
        ContentType contentType = null;
        if (exchange != null) {
            contentEncoding = (String)exchange.getIn().getHeader("Content-Encoding", String.class);
            String contentTypeAsString = ExchangeHelper.getContentType((Exchange)exchange);
            if (contentTypeAsString != null) {
                contentType = ContentType.parse((CharSequence)contentTypeAsString);
            }
        }
        if (exchange != null && !((Boolean)exchange.getProperty("CamelSkipGzipEncoding", (Object)Boolean.FALSE, Boolean.class)).booleanValue()) {
            InputStream stream = GZIPHelper.compressGzip((String)contentEncoding, (InputStream)in);
            int available = stream.available();
            entity = new InputStreamEntity(stream, stream instanceof ByteArrayInputStream ? (available != 0 ? (long)available : -1L) : -1L, contentType, contentEncoding);
        } else {
            entity = new InputStreamEntity(in, -1L, contentType, contentEncoding);
        }
        return entity;
    }

    private static HttpEntity asHttpEntity(byte[] data, Exchange exchange) throws Exception {
        ByteArrayEntity entity;
        String contentEncoding = null;
        ContentType contentType = null;
        if (exchange != null) {
            contentEncoding = (String)exchange.getIn().getHeader("Content-Encoding", String.class);
            String contentTypeAsString = ExchangeHelper.getContentType((Exchange)exchange);
            if (contentTypeAsString != null) {
                contentType = ContentType.parse((CharSequence)contentTypeAsString);
            }
        }
        if (exchange != null && !((Boolean)exchange.getProperty("CamelSkipGzipEncoding", (Object)Boolean.FALSE, Boolean.class)).booleanValue()) {
            boolean gzip = GZIPHelper.isGzip((String)contentEncoding);
            if (gzip) {
                InputStream stream = GZIPHelper.compressGzip((String)contentEncoding, (byte[])data);
                int available = stream.available();
                entity = new InputStreamEntity(stream, stream instanceof ByteArrayInputStream ? (available != 0 ? (long)available : -1L) : -1L, contentType, contentEncoding);
            } else {
                entity = new ByteArrayEntity(data, contentType, contentEncoding);
            }
        } else {
            entity = new ByteArrayEntity(data, contentType, contentEncoding);
        }
        return entity;
    }
}

