/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.BearerToken;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.CredentialsStore;
import org.apache.hc.client5.http.auth.NTCredentials;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.utils.Base64;

public final class HttpCredentialsHelper {
    private final CredentialsStore credentialsProvider = new BasicCredentialsProvider();

    HttpCredentialsHelper() {
    }

    public CredentialsProvider getCredentialsProvider(String host, Integer port, Credentials credentials) {
        this.credentialsProvider.setCredentials(new AuthScope(host, Objects.requireNonNullElse(port, -1).intValue()), credentials);
        return this.credentialsProvider;
    }

    public static String generateBasicAuthHeader(String user, String pass) {
        String auth = user + ":" + pass;
        byte[] encodedAuth = Base64.encodeBase64((byte[])auth.getBytes(StandardCharsets.UTF_8));
        return "Basic " + new String(encodedAuth);
    }

    public static Credentials getCredentials(String method, String username, String password, String host, String domain, String token) {
        if ("BEARER".equalsIgnoreCase(method)) {
            return new BearerToken(token);
        }
        if (username != null && password != null) {
            if ("NTLM".equalsIgnoreCase(method)) {
                return new NTCredentials(username, password.toCharArray(), host, domain);
            }
            return new UsernamePasswordCredentials(username, password.toCharArray());
        }
        return null;
    }
}

