/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.util.List;
import org.apache.camel.component.http.HttpClientConfigurer;
import org.apache.camel.component.http.HttpCredentialsHelper;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.NTCredentials;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.auth.BasicSchemeFactory;
import org.apache.hc.client5.http.impl.auth.BearerSchemeFactory;
import org.apache.hc.client5.http.impl.auth.DigestSchemeFactory;
import org.apache.hc.client5.http.impl.auth.NTLMSchemeFactory;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;

public class BasicAuthenticationHttpClientConfigurer
implements HttpClientConfigurer {
    private final String username;
    private final char[] password;
    private final String domain;
    private final String host;
    private final HttpCredentialsHelper credentialsHelper;

    public BasicAuthenticationHttpClientConfigurer(String user, String pwd, String domain, String host, HttpCredentialsHelper credentialsHelper) {
        this.username = user;
        this.password = pwd == null ? new char[]{} : pwd.toCharArray();
        this.domain = domain;
        this.host = host;
        this.credentialsHelper = credentialsHelper;
    }

    @Override
    public void configureHttpClient(HttpClientBuilder clientBuilder) {
        UsernamePasswordCredentials defaultcreds;
        if (this.domain != null) {
            defaultcreds = new NTCredentials(this.username, this.password, this.host, this.domain);
            Registry copy = RegistryBuilder.create().register("Basic", (Object)BasicSchemeFactory.INSTANCE).register("Digest", (Object)DigestSchemeFactory.INSTANCE).register("Bearer", (Object)BearerSchemeFactory.INSTANCE).register("NTLM", (Object)NTLMSchemeFactory.INSTANCE).build();
            RequestConfig requestConfig = RequestConfig.custom().setTargetPreferredAuthSchemes(List.of("NTLM")).build();
            clientBuilder.setDefaultAuthSchemeRegistry((Lookup)copy).setDefaultRequestConfig(requestConfig);
        } else {
            defaultcreds = new UsernamePasswordCredentials(this.username, this.password);
        }
        clientBuilder.setDefaultCredentialsProvider(this.credentialsHelper.getCredentialsProvider(this.host, null, (Credentials)defaultcreds));
    }
}

