/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.Message;
import org.apache.camel.component.http.HttpExchange;
import org.apache.camel.component.http.HttpMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpBinding {
    public static final Set<String> DEFAULT_HEADERS_TO_IGNORE = new HashSet<String>(Arrays.asList("content-length", "content-type", "http.responseCode".toLowerCase()));
    private Set<String> ignoredHeaders = DEFAULT_HEADERS_TO_IGNORE;
    private boolean useReaderForPayload = false;

    public void writeResponse(HttpExchange exchange, HttpServletResponse response) throws IOException {
        Message out = exchange.getOut();
        if (out != null) {
            if (out.getHeader("http.responseCode") != null) {
                int responseCode = (Integer)out.getHeader("http.responseCode");
                response.setStatus(responseCode);
            }
            for (String key : out.getHeaders().keySet()) {
                String value;
                if (!this.shouldHeaderBePropagated(key, value = (String)out.getHeader(key, String.class))) continue;
                response.setHeader(key, value);
            }
            if (out.getBody() != null) {
                InputStream is = (InputStream)out.getBody(InputStream.class);
                if (is != null) {
                    int c;
                    ServletOutputStream os = response.getOutputStream();
                    while ((c = is.read()) >= 0) {
                        os.write(c);
                    }
                } else {
                    String data = (String)out.getBody(String.class);
                    if (data != null) {
                        response.getWriter().print(data);
                    }
                }
            }
        }
    }

    public Object parseBody(HttpMessage httpMessage) throws IOException {
        HttpServletRequest request = httpMessage.getRequest();
        if (this.isUseReaderForPayload()) {
            return request.getReader();
        }
        return request.getInputStream();
    }

    public boolean shouldHeaderBePropagated(String headerName, String headerValue) {
        if (headerValue == null) {
            return false;
        }
        if (headerName.startsWith("org.apache.camel")) {
            return false;
        }
        return !this.getIgnoredHeaders().contains(headerName.toLowerCase());
    }

    public void setIgnoredHeaders(Set<String> headersToIgnore) {
        this.ignoredHeaders = headersToIgnore;
    }

    public Set<String> getIgnoredHeaders() {
        return this.ignoredHeaders;
    }

    public boolean isUseReaderForPayload() {
        return this.useReaderForPayload;
    }

    public void setUseReaderForPayload(boolean useReaderForPayload) {
        this.useReaderForPayload = useReaderForPayload;
    }
}

