/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.http.common;

import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.InputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.Message;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.http.common.HttpConverter;
import org.apache.camel.http.common.HttpMessage;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;

@DeferredContextBinding
public final class HttpConverterLoader
implements TypeConverterLoader,
CamelContextAware {
    private CamelContext camelContext;

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        HttpConverterLoader.addTypeConverter(registry, ServletInputStream.class, HttpMessage.class, false, (type, exchange, value) -> {
            ServletInputStream answer = HttpConverter.toServletInputStream((HttpMessage)((Object)((Object)value)));
            return answer;
        });
        HttpConverterLoader.addTypeConverter(registry, HttpServletRequest.class, Message.class, false, (type, exchange, value) -> {
            HttpServletRequest answer = HttpConverter.toServletRequest((Message)value);
            return answer;
        });
        HttpConverterLoader.addTypeConverter(registry, HttpServletResponse.class, Message.class, false, (type, exchange, value) -> {
            HttpServletResponse answer = HttpConverter.toServletResponse((Message)value);
            return answer;
        });
        HttpConverterLoader.addTypeConverter(registry, BufferedReader.class, HttpMessage.class, false, (type, exchange, value) -> {
            BufferedReader answer = HttpConverter.toReader((HttpMessage)((Object)((Object)value)));
            return answer;
        });
        HttpConverterLoader.addTypeConverter(registry, InputStream.class, HttpServletRequest.class, false, (type, exchange, value) -> {
            InputStream answer = HttpConverter.toInputStream((HttpServletRequest)value, exchange);
            return answer;
        });
        HttpConverterLoader.addTypeConverter(registry, InputStream.class, HttpMessage.class, false, (type, exchange, value) -> {
            InputStream answer = HttpConverter.toInputStream((HttpMessage)((Object)((Object)value)), exchange);
            return answer;
        });
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

