/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hl7;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;
import java.nio.charset.Charset;
import org.apache.camel.component.hl7.HL7MLLPConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HL7MLLPNettyDecoder
extends DelimiterBasedFrameDecoder {
    private static final Logger LOG = LoggerFactory.getLogger(HL7MLLPNettyDecoder.class);
    private static final int MAX_FRAME_LENGTH = Integer.MAX_VALUE;
    private final HL7MLLPConfig config;

    HL7MLLPNettyDecoder() {
        this(new HL7MLLPConfig());
    }

    HL7MLLPNettyDecoder(HL7MLLPConfig config) {
        super(Integer.MAX_VALUE, true, Unpooled.copiedBuffer((char[])new char[]{config.getEndByte1(), config.getEndByte2()}, (Charset)Charset.defaultCharset()));
        this.config = config;
    }

    protected Object decode(ChannelHandlerContext ctx, ByteBuf buffer) throws Exception {
        ByteBuf buf = (ByteBuf)super.decode(ctx, buffer);
        if (buf != null) {
            try {
                int pos = buf.bytesBefore((byte)this.config.getStartByte());
                if (pos >= 0) {
                    ByteBuf msg = buf.readerIndex(pos + 1).slice();
                    LOG.debug("Message ends with length {}", (Object)msg.readableBytes());
                    Object object = this.config.isProduceString() ? this.asString(msg) : (Object)this.asByteArray(msg);
                    return object;
                }
                throw new DecoderException("Did not find start byte " + this.config.getStartByte());
            }
            finally {
                buf.release();
            }
        }
        LOG.debug("No complete messages yet at position {}", (Object)buffer.readableBytes());
        return null;
    }

    private byte[] asByteArray(ByteBuf msg) {
        byte[] bytes = new byte[msg.readableBytes()];
        msg.getBytes(0, bytes);
        if (this.config.isConvertLFtoCR()) {
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i] != 10) continue;
                bytes[i] = 13;
            }
        }
        return bytes;
    }

    private String asString(ByteBuf msg) {
        String s = msg.toString(this.config.getCharset());
        if (this.config.isConvertLFtoCR()) {
            return s.replace('\n', '\r');
        }
        return s;
    }
}

