/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hl7;

import ca.uhn.hl7v2.model.Message;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import org.apache.camel.dataformat.hl7.HL7Converter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;

public class HL7MLLPCodec
implements ProtocolCodecFactory {
    private static final transient Log LOG = LogFactory.getLog(HL7MLLPCodec.class);
    private static final String CHARSET_ENCODER = HL7MLLPCodec.class.getName() + ".charsetencoder";
    private static final String CHARSET_DECODER = HL7MLLPCodec.class.getName() + ".charsetdecoder";
    private char startByte = (char)11;
    private char endByte1 = (char)28;
    private char endByte2 = (char)13;
    private Charset charset = Charset.defaultCharset();
    private boolean convertLFtoCR = true;

    public ProtocolEncoder getEncoder() throws Exception {
        return new ProtocolEncoder(){

            public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws Exception {
                String body;
                if (message == null) {
                    throw new IllegalArgumentException("Message to encode is null");
                }
                if (message instanceof Exception) {
                    throw (Exception)message;
                }
                CharsetEncoder encoder = (CharsetEncoder)session.getAttribute(CHARSET_ENCODER);
                if (encoder == null) {
                    encoder = HL7MLLPCodec.this.charset.newEncoder();
                    session.setAttribute(CHARSET_ENCODER, (Object)encoder);
                }
                if (message instanceof Message) {
                    body = HL7Converter.toString((Message)message);
                } else if (message instanceof String) {
                    body = (String)message;
                } else if (message instanceof byte[]) {
                    body = new String((byte[])message);
                } else {
                    throw new IllegalArgumentException("The message to encode is not a supported type: " + message.getClass().getCanonicalName());
                }
                if (HL7MLLPCodec.this.convertLFtoCR) {
                    body = body.replace('\n', '\r');
                }
                ByteBuffer bb = ByteBuffer.allocate((int)(body.length() + 3)).setAutoExpand(true);
                bb.put((byte)HL7MLLPCodec.this.startByte);
                bb.putString((CharSequence)body, encoder);
                bb.put((byte)HL7MLLPCodec.this.endByte1);
                bb.put((byte)HL7MLLPCodec.this.endByte2);
                bb.flip();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Encoding HL7 from " + message.getClass().getCanonicalName() + " to byte stream"));
                }
                out.write(bb);
            }

            public void dispose(IoSession session) throws Exception {
                session.removeAttribute(CHARSET_ENCODER);
            }
        };
    }

    public ProtocolDecoder getDecoder() throws Exception {
        return new ProtocolDecoder(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void decode(IoSession session, ByteBuffer in, ProtocolDecoderOutput out) throws Exception {
                int posEnd = 0;
                int posStart = 0;
                while (in.hasRemaining()) {
                    byte b = in.get();
                    if (b == HL7MLLPCodec.this.startByte) {
                        posStart = in.position();
                    }
                    if (b != HL7MLLPCodec.this.endByte1) continue;
                    byte next = in.get();
                    if (next == HL7MLLPCodec.this.endByte2) {
                        posEnd = in.position() - 2;
                        break;
                    }
                    LOG.warn((Object)("The 2nd end byte " + HL7MLLPCodec.this.endByte2 + " was not found, but was " + b));
                }
                in.rewind();
                in.skip(posStart);
                if (posEnd > 0) {
                    in.limit(posEnd);
                }
                try {
                    CharsetDecoder decoder = (CharsetDecoder)session.getAttribute(CHARSET_DECODER);
                    if (decoder == null) {
                        decoder = HL7MLLPCodec.this.charset.newDecoder();
                        session.setAttribute(CHARSET_DECODER, (Object)decoder);
                    }
                    String body = in.getString(decoder);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Decoding HL7 from byte stream to String");
                    }
                    out.write((Object)body);
                }
                finally {
                    in.clear();
                }
            }

            public void finishDecode(IoSession session, ProtocolDecoderOutput out) throws Exception {
            }

            public void dispose(IoSession session) throws Exception {
                session.removeAttribute(CHARSET_DECODER);
            }
        };
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void setCharset(String charsetName) {
        this.charset = Charset.forName(charsetName);
    }

    public boolean isConvertLFtoCR() {
        return this.convertLFtoCR;
    }

    public void setConvertLFtoCR(boolean convertLFtoCR) {
        this.convertLFtoCR = convertLFtoCR;
    }

    public char getStartByte() {
        return this.startByte;
    }

    public void setStartByte(char startByte) {
        this.startByte = startByte;
    }

    public char getEndByte1() {
        return this.endByte1;
    }

    public void setEndByte1(char endByte1) {
        this.endByte1 = endByte1;
    }

    public char getEndByte2() {
        return this.endByte2;
    }

    public void setEndByte2(char endByte2) {
        this.endByte2 = endByte2;
    }
}

