/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.hl7;

import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.util.Terser;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.dataformat.hl7.HL7Converter;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.util.ExchangeHelper;

public class HL7DataFormat
implements DataFormat {
    public void marshal(Exchange exchange, Object body, OutputStream outputStream) throws Exception {
        Message message = (Message)ExchangeHelper.convertToMandatoryType((Exchange)exchange, Message.class, (Object)body);
        String encoded = HL7Converter.toString(message);
        outputStream.write(encoded.getBytes());
    }

    public Object unmarshal(Exchange exchange, InputStream inputStream) throws Exception {
        String body = (String)ExchangeHelper.convertToMandatoryType((Exchange)exchange, String.class, (Object)inputStream);
        Message message = HL7Converter.toMessage(body);
        Terser terser = new Terser(message);
        exchange.getOut().setHeader("hl7.msh.sendingApplication", (Object)terser.get("MSH-3"));
        exchange.getOut().setHeader("hl7.msh.sendingFacility", (Object)terser.get("MSH-4"));
        exchange.getOut().setHeader("hl7.msh.receivingApplication", (Object)terser.get("MSH-5"));
        exchange.getOut().setHeader("hl7.msh.receivingFacility", (Object)terser.get("MSH-6"));
        exchange.getOut().setHeader("hl7.msh.timestamp", (Object)terser.get("MSH-7"));
        exchange.getOut().setHeader("hl7.msh.security", (Object)terser.get("MSH-8"));
        exchange.getOut().setHeader("hl7.msh.messageType", (Object)terser.get("MSH-9-1"));
        exchange.getOut().setHeader("hl7.msh.triggerEvent", (Object)terser.get("MSH-9-2"));
        exchange.getOut().setHeader("hl7.msh.messageControl", (Object)terser.get("MSH-10"));
        exchange.getOut().setHeader("hl7.msh.processingId", (Object)terser.get("MSH-11"));
        exchange.getOut().setHeader("hl7.msh.versionId", (Object)terser.get("MSH-12"));
        return message;
    }
}

