/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.health;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.camel.CamelContext;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckResolver;
import org.apache.camel.spi.PackageScanResourceResolver;
import org.apache.camel.spi.Resource;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHealthChecksLoader {
    public static final String META_INF_SERVICES = "META-INF/services/org/apache/camel/health-check";
    private static final Logger LOG = LoggerFactory.getLogger(DefaultHealthChecksLoader.class);
    protected final CamelContext camelContext;
    protected final PackageScanResourceResolver resolver;
    protected final HealthCheckResolver healthCheckResolver;

    public DefaultHealthChecksLoader(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.resolver = PluginHelper.getPackageScanResourceResolver((CamelContext)camelContext);
        this.healthCheckResolver = PluginHelper.getHealthCheckResolver((CamelContext)camelContext);
    }

    public Collection<HealthCheck> loadHealthChecks() {
        ArrayList<HealthCheck> answer = new ArrayList<HealthCheck>();
        LOG.trace("Searching for {} health checks", (Object)META_INF_SERVICES);
        try {
            Collection resources = this.resolver.findResources("META-INF/services/org/apache/camel/health-check/*-check");
            if (LOG.isDebugEnabled()) {
                LOG.debug("Discovered {} health checks from classpath scanning", (Object)resources.size());
            }
            for (Resource resource : resources) {
                LOG.trace("Resource: {}", (Object)resource);
                if (!this.acceptResource(resource)) continue;
                String id = this.extractId(resource);
                LOG.trace("Loading HealthCheck: {}", (Object)id);
                HealthCheck hc = this.healthCheckResolver.resolveHealthCheck(id);
                if (hc == null) continue;
                LOG.debug("Loaded HealthCheck: {}/{}", (Object)hc.getGroup(), (Object)hc.getId());
                answer.add(hc);
            }
        }
        catch (Exception e) {
            LOG.warn("Error during scanning for custom health-checks on classpath due to: {}. This exception is ignored.", (Object)e.getMessage());
        }
        return answer;
    }

    protected boolean acceptResource(Resource resource) {
        String loc = resource.getLocation();
        if (loc == null) {
            return false;
        }
        return !loc.endsWith("context-check");
    }

    protected String extractId(Resource resource) {
        String loc = resource.getLocation();
        if ((loc = StringHelper.after((String)loc, (String)"META-INF/services/org/apache/camel/health-check/")) != null && loc.endsWith("-check")) {
            loc = loc.substring(0, loc.length() - 6);
        }
        return loc;
    }
}

