/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hdfs.kerberos;

import java.io.File;
import org.apache.camel.component.hdfs.HdfsConfiguration;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KerberosConfigurationBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosConfigurationBuilder.class);
    private static final String KERBEROS_5_SYS_ENV = "java.security.krb5.conf";
    private static final String AUTHENTICATION_MODE = "hadoop.security.authentication";

    private KerberosConfigurationBuilder() {
    }

    public static void withKerberosConfiguration(Configuration configuration, HdfsConfiguration endpointConfig) {
        KerberosConfigurationBuilder.setKerberosConfigFile(endpointConfig.getKerberosConfigFileLocation());
        configuration.set(AUTHENTICATION_MODE, "kerberos");
    }

    public static void setKerberosConfigFile(String kerberosConfigFileLocation) {
        if (!new File(kerberosConfigFileLocation).exists()) {
            LOG.warn("Kerberos configuration file [{}}] could not be found.", (Object)kerberosConfigFileLocation);
            return;
        }
        String krb5Conf = System.getProperty(KERBEROS_5_SYS_ENV);
        if (krb5Conf == null || !krb5Conf.isEmpty()) {
            System.setProperty(KERBEROS_5_SYS_ENV, kerberosConfigFileLocation);
        } else if (!krb5Conf.equalsIgnoreCase(kerberosConfigFileLocation)) {
            LOG.warn("[{}] was already configured with: [{}] config file", (Object)KERBEROS_5_SYS_ENV, (Object)krb5Conf);
        }
    }
}

