/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.grpc.client;

import io.grpc.stub.StreamObserver;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProducer;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Service;
import org.apache.camel.component.grpc.GrpcConfiguration;
import org.apache.camel.component.grpc.client.GrpcResponseAggregationStreamObserver;
import org.apache.camel.component.grpc.client.GrpcResponseRouterStreamObserver;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;

public class GrpcStreamObserverFactory
extends ServiceSupport {
    private final Endpoint sourceEndpoint;
    private final GrpcConfiguration configuration;
    private Endpoint endpoint;
    private AsyncProducer producer;

    public GrpcStreamObserverFactory(Endpoint sourceEndpoint, GrpcConfiguration configuration) {
        this.sourceEndpoint = sourceEndpoint;
        this.configuration = configuration;
    }

    public StreamObserver<Object> getStreamObserver(Exchange exchange, AsyncCallback callback) {
        if (this.configuration.getStreamRepliesTo() == null) {
            return new GrpcResponseAggregationStreamObserver(exchange, callback);
        }
        return new GrpcResponseRouterStreamObserver(this.configuration, this.sourceEndpoint, this.producer, exchange, callback);
    }

    protected void doStart() throws Exception {
        if (this.configuration.getStreamRepliesTo() != null) {
            this.endpoint = CamelContextHelper.getMandatoryEndpoint((CamelContext)this.sourceEndpoint.getCamelContext(), (String)this.configuration.getStreamRepliesTo());
            this.producer = this.endpoint.createAsyncProducer();
            ServiceHelper.startService((Service)this.producer);
        }
    }

    protected void doStop() throws Exception {
        if (this.configuration.getStreamRepliesTo() != null) {
            ServiceHelper.stopService((Service)this.producer);
        }
    }
}

