/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.groovy;

import groovy.lang.Script;
import org.apache.camel.Service;
import org.apache.camel.language.groovy.GroovyExpression;
import org.apache.camel.support.LanguageSupport;
import org.apache.camel.util.LRUSoftCache;
import org.codehaus.groovy.runtime.InvokerHelper;

public class GroovyLanguage
extends LanguageSupport {
    private final LRUSoftCache<String, GroovyClassService> scriptCache = new LRUSoftCache(16, 1000, true);

    public static GroovyExpression groovy(String expression) {
        return new GroovyLanguage().createExpression(expression);
    }

    public GroovyExpression createPredicate(String expression) {
        return this.createExpression(expression);
    }

    public GroovyExpression createExpression(String expression) {
        expression = this.loadResource(expression);
        return new GroovyExpression(expression);
    }

    Class<Script> getScriptFromCache(String script) {
        GroovyClassService cached = (GroovyClassService)this.scriptCache.get((Object)script);
        if (cached == null) {
            return null;
        }
        return cached.script;
    }

    void addScriptToCache(String script, Class<Script> scriptClass) {
        this.scriptCache.put((Object)script, (Object)new GroovyClassService(scriptClass));
    }

    private static final class GroovyClassService
    implements Service {
        private final Class<Script> script;

        private GroovyClassService(Class<Script> script) {
            this.script = script;
        }

        public void start() throws Exception {
        }

        public void stop() throws Exception {
            InvokerHelper.removeClass(this.script);
        }
    }
}

