/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.grape;

public class MavenCoordinates {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String classifier;

    MavenCoordinates(String groupId, String artifactId, String version, String classifier) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.classifier = classifier;
    }

    public static MavenCoordinates parseMavenCoordinates(String coordinates) {
        String[] coordinatesParts = coordinates.split("/");
        String clazzifier = "";
        if (coordinatesParts.length < 3 || coordinatesParts.length > 4) {
            throw new IllegalArgumentException("Invalid coordinates: " + coordinates);
        }
        if (coordinatesParts.length == 4) {
            clazzifier = coordinatesParts[3];
        }
        return new MavenCoordinates(coordinatesParts[0], coordinatesParts[1], coordinatesParts[2], clazzifier);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getClassifier() {
        return this.classifier;
    }
}

