/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.sheets;

import com.google.api.services.sheets.v4.Sheets;
import java.util.Map;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.google.sheets.GoogleSheetsClientFactory;
import org.apache.camel.component.google.sheets.GoogleSheetsComponent;
import org.apache.camel.component.google.sheets.GoogleSheetsConfiguration;
import org.apache.camel.component.google.sheets.GoogleSheetsConsumer;
import org.apache.camel.component.google.sheets.GoogleSheetsProducer;
import org.apache.camel.component.google.sheets.internal.GoogleSheetsApiCollection;
import org.apache.camel.component.google.sheets.internal.GoogleSheetsApiName;
import org.apache.camel.component.google.sheets.internal.GoogleSheetsPropertiesHelper;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.component.AbstractApiEndpoint;
import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodPropertiesHelper;
import org.apache.camel.support.component.ApiName;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="2.23.0", scheme="google-sheets", title="Google Sheets", syntax="google-sheets:apiName/methodName", apiSyntax="apiName/methodName", category={Category.CLOUD, Category.DOCUMENT})
public class GoogleSheetsEndpoint
extends AbstractApiEndpoint<GoogleSheetsApiName, GoogleSheetsConfiguration>
implements EndpointServiceLocation {
    @UriParam
    private GoogleSheetsConfiguration configuration;
    private Object apiProxy;

    public GoogleSheetsEndpoint(String uri, GoogleSheetsComponent component, GoogleSheetsApiName apiName, String methodName, GoogleSheetsConfiguration endpointConfiguration) {
        super(uri, (Component)component, (ApiName)apiName, methodName, GoogleSheetsApiCollection.getCollection().getHelper(apiName), (Object)endpointConfiguration);
        this.configuration = endpointConfiguration;
    }

    public Producer createProducer() throws Exception {
        return new GoogleSheetsProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        if (this.inBody != null) {
            throw new IllegalArgumentException("Option inBody is not supported for consumer endpoint");
        }
        GoogleSheetsConsumer consumer = new GoogleSheetsConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    protected ApiMethodPropertiesHelper<GoogleSheetsConfiguration> getPropertiesHelper() {
        return GoogleSheetsPropertiesHelper.getHelper(this.getCamelContext());
    }

    protected String getThreadProfileName() {
        return "CamelGoogleSheets";
    }

    protected void afterConfigureProperties() {
        switch ((GoogleSheetsApiName)this.apiName) {
            case SPREADSHEETS: {
                this.apiProxy = this.getClient().spreadsheets();
                break;
            }
            case DATA: {
                this.apiProxy = this.getClient().spreadsheets().values();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid API name " + String.valueOf(this.apiName));
            }
        }
    }

    public Sheets getClient() {
        return ((GoogleSheetsComponent)this.getComponent()).getClient(this.configuration);
    }

    public Object getApiProxy(ApiMethod method, Map<String, Object> args) {
        return this.apiProxy;
    }

    public GoogleSheetsClientFactory getClientFactory() {
        return ((GoogleSheetsComponent)this.getComponent()).getClientFactory();
    }

    public void setClientFactory(GoogleSheetsClientFactory clientFactory) {
        ((GoogleSheetsComponent)this.getComponent()).setClientFactory(clientFactory);
    }

    public String getServiceUrl() {
        if (ObjectHelper.isNotEmpty((Object)(ObjectHelper.isNotEmpty((Object)((Object)this.configuration.getApiName())) && ObjectHelper.isNotEmpty((String)this.configuration.getMethodName()) ? 1 : 0))) {
            return this.getServiceProtocol() + ":" + String.valueOf((Object)this.configuration.getApiName()) + ":" + this.configuration.getMethodName();
        }
        return null;
    }

    public String getServiceProtocol() {
        return "sheets";
    }

    public Map<String, String> getServiceMetadata() {
        if (this.configuration.getApplicationName() != null) {
            return Map.of("applicationName", this.configuration.getApplicationName());
        }
        return null;
    }
}

