/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.sheets.transform;

import java.util.StringJoiner;
import org.apache.camel.component.google.sheets.transform.CellCoordinate;

public final class RangeCoordinate
extends CellCoordinate {
    public static final String DIMENSION_ROWS = "ROWS";
    public static final String DIMENSION_COLUMNS = "COLUMNS";
    private int rowStartIndex;
    private int rowEndIndex;
    private int columnStartIndex;
    private int columnEndIndex;

    private RangeCoordinate() {
    }

    public static RangeCoordinate fromRange(String range) {
        RangeCoordinate coordinate = new RangeCoordinate();
        String rangeExpression = RangeCoordinate.normalizeRange(range);
        if (rangeExpression.contains(":")) {
            String[] coordinates = rangeExpression.split(":", -1);
            coordinate.setRowStartIndex(RangeCoordinate.getRowIndex(coordinates[0]));
            coordinate.setColumnStartIndex(RangeCoordinate.getColumnIndex(coordinates[0]));
            coordinate.setRowEndIndex(RangeCoordinate.getRowIndex(coordinates[1]) + 1);
            coordinate.setColumnEndIndex(RangeCoordinate.getColumnIndex(coordinates[1]) + 1);
        } else {
            CellCoordinate cellCoordinate = CellCoordinate.fromCellId(rangeExpression);
            coordinate.setRowIndex(cellCoordinate.getRowIndex());
            coordinate.setColumnIndex(cellCoordinate.getColumnIndex());
            coordinate.setRowStartIndex(cellCoordinate.getRowIndex());
            coordinate.setColumnStartIndex(cellCoordinate.getColumnIndex());
            coordinate.setRowEndIndex(cellCoordinate.getRowIndex() + 1);
            coordinate.setColumnEndIndex(cellCoordinate.getColumnIndex() + 1);
        }
        return coordinate;
    }

    private static String normalizeRange(String range) {
        if (range.contains("!")) {
            return range.substring(range.indexOf(33) + 1);
        }
        return range;
    }

    public String getColumnNames() {
        StringJoiner delimitedList = new StringJoiner(",");
        for (int i = this.columnStartIndex; i < this.columnEndIndex; ++i) {
            delimitedList.add(CellCoordinate.getColumnName(i));
        }
        return delimitedList.toString();
    }

    public int getRowStartIndex() {
        return this.rowStartIndex;
    }

    public void setRowStartIndex(int rowStartIndex) {
        this.rowStartIndex = rowStartIndex;
    }

    public int getRowEndIndex() {
        return this.rowEndIndex;
    }

    public void setRowEndIndex(int rowEndIndex) {
        this.rowEndIndex = rowEndIndex;
    }

    public int getColumnStartIndex() {
        return this.columnStartIndex;
    }

    public void setColumnStartIndex(int columnStartIndex) {
        this.columnStartIndex = columnStartIndex;
    }

    public int getColumnEndIndex() {
        return this.columnEndIndex;
    }

    public void setColumnEndIndex(int columnEndIndex) {
        this.columnEndIndex = columnEndIndex;
    }
}

