/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.sheets.transform;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.api.services.sheets.v4.model.ValueRange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.component.google.sheets.transform.CellCoordinate;
import org.apache.camel.component.google.sheets.transform.RangeCoordinate;
import org.apache.camel.component.jackson.transform.Json;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeTransformer;
import org.apache.camel.spi.Transformer;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.util.ObjectHelper;

@DataTypeTransformer(name="google-sheets:application-x-struct", description="Transforms to/from JSon data and Google Sheets ValueRange object")
public class GoogleSheetsJsonStructDataTypeTransformer
extends Transformer {
    private static final String ROW_PREFIX = "#";

    public void transform(Message message, DataType fromType, DataType toType) {
        Optional<ValueRange> valueRange = GoogleSheetsJsonStructDataTypeTransformer.getValueRangeBody(message);
        String range = message.getHeader("CamelGoogleSheets.range", (Object)"A:A").toString();
        String majorDimension = message.getHeader("CamelGoogleSheets.majorDimension", (Object)"ROWS").toString();
        String spreadsheetId = message.getHeader("CamelGoogleSheets.spreadsheetId", (Object)"").toString();
        String[] columnNames = message.getHeader("CamelGoogleSheets.columnNames", (Object)"A").toString().split(",");
        boolean splitResults = Boolean.parseBoolean(message.getHeader("CamelGoogleSheets.splitResults", (Object)"false").toString());
        if (valueRange.isPresent()) {
            message.setBody(this.transformFromValueRangeModel(message, valueRange.get(), spreadsheetId, range, majorDimension, columnNames));
        } else if (splitResults) {
            message.setBody((Object)this.transformFromSplitValuesModel(message, spreadsheetId, range, majorDimension, columnNames));
        } else {
            String valueInputOption = message.getHeader("CamelGoogleSheets.valueInputOption", (Object)"USER_ENTERED").toString();
            message.setBody((Object)this.transformToValueRangeModel(message, spreadsheetId, range, majorDimension, valueInputOption, columnNames));
        }
    }

    private ValueRange transformToValueRangeModel(Message message, String spreadsheetId, String range, String majorDimension, String valueInputOption, String[] columnNames) {
        try {
            List<String> jsonBeans = GoogleSheetsJsonStructDataTypeTransformer.bodyAsJsonBeans(message);
            ValueRange valueRange = new ValueRange();
            ArrayList values = new ArrayList();
            if (ObjectHelper.isNotEmpty(jsonBeans)) {
                ArrayList<String> properties = GoogleSheetsJsonStructDataTypeTransformer.createCoordinateNameSpec(range, majorDimension, columnNames);
                for (String json : jsonBeans) {
                    Map dataShape = (Map)Json.mapper().reader().forType(Map.class).readValue(json);
                    if (dataShape.containsKey("spreadsheetId")) {
                        spreadsheetId = Optional.ofNullable(dataShape.remove("spreadsheetId")).map(Object::toString).orElse(spreadsheetId);
                    }
                    ArrayList rangeValues = new ArrayList();
                    properties.stream().filter(specEntry -> !Objects.equals("spreadsheetId", specEntry)).forEach(specEntry -> rangeValues.add(dataShape.getOrDefault(specEntry, null)));
                    values.add(rangeValues);
                }
            }
            valueRange.setMajorDimension(majorDimension);
            valueRange.setValues(values);
            message.setHeader("CamelGoogleSheetsSpreadsheetId", (Object)spreadsheetId);
            message.setHeader("CamelGoogleSheets.spreadsheetId", (Object)spreadsheetId);
            message.setHeader("CamelGoogleSheetsRange", (Object)range);
            message.setHeader("CamelGoogleSheets.range", (Object)range);
            message.setHeader("CamelGoogleSheetsMajorDimension", (Object)majorDimension);
            message.setHeader("CamelGoogleSheets.majorDimension", (Object)majorDimension);
            message.setHeader("CamelGoogleSheets.valueInputOption", (Object)valueInputOption);
            message.setHeader("CamelGoogleSheets.values", (Object)valueRange);
            return valueRange;
        }
        catch (JsonProcessingException | InvalidPayloadException e) {
            throw new CamelExecutionException("Failed to apply Google Sheets Json struct data type on exchange", message.getExchange(), e);
        }
    }

    private List<String> transformFromValueRangeModel(Message message, ValueRange valueRange, String spreadsheetId, String range, String majorDimension, String[] columnNames) {
        ArrayList<String> jsonBeans = new ArrayList<String>();
        try {
            if (valueRange != null) {
                if (ObjectHelper.isNotEmpty((String)valueRange.getRange())) {
                    range = valueRange.getRange();
                }
                RangeCoordinate rangeCoordinate = RangeCoordinate.fromRange(range);
                if (ObjectHelper.isNotEmpty((String)valueRange.getMajorDimension())) {
                    majorDimension = valueRange.getMajorDimension();
                }
                if (ObjectHelper.equal((Object)"ROWS", (Object)majorDimension)) {
                    for (List values : valueRange.getValues()) {
                        HashMap<String, String> model = new HashMap<String, String>();
                        model.put("spreadsheetId", spreadsheetId);
                        int columnIndex = rangeCoordinate.getColumnStartIndex();
                        for (Object value : values) {
                            model.put(CellCoordinate.getColumnName(columnIndex, rangeCoordinate.getColumnStartIndex(), columnNames), (String)value);
                            ++columnIndex;
                        }
                        jsonBeans.add(Json.mapper().writer().writeValueAsString(model));
                    }
                } else if (ObjectHelper.equal((Object)"COLUMNS", (Object)majorDimension)) {
                    for (List values : valueRange.getValues()) {
                        HashMap<Object, String> model = new HashMap<Object, String>();
                        model.put("spreadsheetId", spreadsheetId);
                        int rowIndex = rangeCoordinate.getRowStartIndex() + 1;
                        for (Object value : values) {
                            model.put(ROW_PREFIX + rowIndex, (String)value);
                            ++rowIndex;
                        }
                        jsonBeans.add(Json.mapper().writer().writeValueAsString(model));
                    }
                }
            }
        }
        catch (IOException e) {
            throw new CamelExecutionException("Failed to apply Google Sheets Json struct data type on exchange", message.getExchange(), (Throwable)e);
        }
        return jsonBeans;
    }

    private String transformFromSplitValuesModel(Message message, String spreadsheetId, String range, String majorDimension, String[] columnNames) {
        try {
            List<String> values = GoogleSheetsJsonStructDataTypeTransformer.bodyAsJsonBeans(message);
            HashMap<Object, String> model = new HashMap<Object, String>();
            model.put("spreadsheetId", spreadsheetId);
            if (values != null) {
                if (ObjectHelper.isNotEmpty((Object)message.getHeader("CamelGoogleSheetsRange"))) {
                    range = message.getHeader("CamelGoogleSheetsRange").toString();
                }
                RangeCoordinate rangeCoordinate = RangeCoordinate.fromRange(range);
                if (ObjectHelper.isNotEmpty((Object)message.getHeader("CamelGoogleSheetsMajorDimension"))) {
                    majorDimension = message.getHeader("CamelGoogleSheetsMajorDimension").toString();
                }
                if (ObjectHelper.equal((Object)"ROWS", (Object)majorDimension)) {
                    int columnIndex = rangeCoordinate.getColumnStartIndex();
                    for (String value : values) {
                        model.put(CellCoordinate.getColumnName(columnIndex, rangeCoordinate.getColumnStartIndex(), columnNames), value);
                        ++columnIndex;
                    }
                } else if (ObjectHelper.equal((Object)"COLUMNS", (Object)majorDimension)) {
                    int rowIndex = rangeCoordinate.getRowStartIndex() + 1;
                    for (String value : values) {
                        model.put(ROW_PREFIX + rowIndex, value);
                        ++rowIndex;
                    }
                }
            }
            return Json.mapper().writer().writeValueAsString(model);
        }
        catch (JsonProcessingException | InvalidPayloadException e) {
            throw new CamelExecutionException("Failed to apply Google Sheets Json struct data type on exchange", message.getExchange(), e);
        }
    }

    private static Optional<ValueRange> getValueRangeBody(Message message) {
        if (message.getBody() instanceof ValueRange) {
            return Optional.of((ValueRange)message.getBody(ValueRange.class));
        }
        String jsonBody = MessageHelper.extractBodyAsString((Message)message);
        if (jsonBody != null) {
            try {
                ValueRange valueRange = (ValueRange)Json.mapper().reader().readValue(jsonBody, ValueRange.class);
                return valueRange.getValues() != null ? Optional.of(valueRange) : Optional.empty();
            }
            catch (IOException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    private static List<String> bodyAsJsonBeans(Message message) throws JsonProcessingException, InvalidPayloadException {
        if (message.getBody() == null) {
            return Collections.emptyList();
        }
        if (message.getBody() instanceof List) {
            return (List)message.getBody(List.class);
        }
        String body = (String)message.getMandatoryBody(String.class);
        if (Json.isJsonArray((String)body)) {
            return Json.arrayToJsonBeans((JsonNode)Json.mapper().reader().readTree(body));
        }
        if (Json.isJson((String)body)) {
            return Collections.singletonList(body);
        }
        return Collections.emptyList();
    }

    public static ArrayList<String> createCoordinateNameSpec(String range, String majorDimension, String ... columnNames) {
        ArrayList<String> names = new ArrayList<String>();
        RangeCoordinate coordinate = RangeCoordinate.fromRange(range);
        if (ObjectHelper.equal((Object)"ROWS", (Object)majorDimension)) {
            GoogleSheetsJsonStructDataTypeTransformer.createSchemaFromRowDimension(names, coordinate, columnNames);
        } else if (ObjectHelper.equal((Object)"COLUMNS", (Object)majorDimension)) {
            GoogleSheetsJsonStructDataTypeTransformer.createSchemaFromColumnDimension(names, coordinate);
        }
        return names;
    }

    private static void createSchemaFromRowDimension(ArrayList<String> properties, RangeCoordinate coordinate, String ... columnNames) {
        for (int i = coordinate.getColumnStartIndex(); i < coordinate.getColumnEndIndex(); ++i) {
            properties.add(CellCoordinate.getColumnName(i, coordinate.getColumnStartIndex(), columnNames));
        }
    }

    private static void createSchemaFromColumnDimension(ArrayList<String> properties, RangeCoordinate coordinate) {
        for (int i = coordinate.getRowStartIndex() + 1; i <= coordinate.getRowEndIndex(); ++i) {
            properties.add(ROW_PREFIX + i);
        }
    }
}

