/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.secret.manager;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.secretmanager.v1.AccessSecretVersionResponse;
import com.google.cloud.secretmanager.v1.SecretManagerServiceClient;
import com.google.cloud.secretmanager.v1.SecretManagerServiceSettings;
import com.google.cloud.secretmanager.v1.SecretVersionName;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.annotations.PropertiesFunction;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.vault.GcpVaultConfiguration;

@PropertiesFunction(value="gcp")
public class GoogleSecretManagerPropertiesFunction
extends ServiceSupport
implements org.apache.camel.spi.PropertiesFunction,
CamelContextAware {
    private static final String CAMEL_VAULT_GCP_SERVICE_ACCOUNT_KEY = "CAMEL_VAULT_GCP_SERVICE_ACCOUNT_KEY";
    private static final String CAMEL_VAULT_GCP_PROJECT_ID = "CAMEL_VAULT_GCP_PROJECT_ID";
    private static final String CAMEL_VAULT_GCP_USE_DEFAULT_INSTANCE = "CAMEL_VAULT_GCP_USE_DEFAULT_INSTANCE";
    boolean useDefaultInstance;
    private CamelContext camelContext;
    private SecretManagerServiceClient client;
    private String projectId;
    private final Set<String> secrets = new HashSet<String>();

    public GoogleSecretManagerPropertiesFunction() {
    }

    public GoogleSecretManagerPropertiesFunction(SecretManagerServiceClient client, String projectId) {
        this.client = client;
        this.projectId = projectId;
    }

    protected void doStart() throws Exception {
        GcpVaultConfiguration gcpVaultConfiguration;
        super.doStart();
        String serviceAccountKey = System.getenv(CAMEL_VAULT_GCP_SERVICE_ACCOUNT_KEY);
        this.useDefaultInstance = Boolean.parseBoolean(System.getenv(CAMEL_VAULT_GCP_USE_DEFAULT_INSTANCE));
        this.projectId = System.getenv(CAMEL_VAULT_GCP_PROJECT_ID);
        if (ObjectHelper.isEmpty((String)serviceAccountKey) && ObjectHelper.isEmpty((String)this.projectId) && ObjectHelper.isNotEmpty((Object)(gcpVaultConfiguration = this.getCamelContext().getVaultConfiguration().gcp()))) {
            serviceAccountKey = gcpVaultConfiguration.getServiceAccountKey();
            this.projectId = gcpVaultConfiguration.getProjectId();
            this.useDefaultInstance = gcpVaultConfiguration.isUseDefaultInstance();
        }
        if (ObjectHelper.isNotEmpty((String)serviceAccountKey) && ObjectHelper.isNotEmpty((String)this.projectId)) {
            InputStream resolveMandatoryResourceAsInputStream = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)this.getCamelContext(), (String)serviceAccountKey);
            ServiceAccountCredentials myCredentials = ServiceAccountCredentials.fromStream((InputStream)resolveMandatoryResourceAsInputStream);
            SecretManagerServiceSettings settings = ((SecretManagerServiceSettings.Builder)SecretManagerServiceSettings.newBuilder().setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)myCredentials))).build();
            this.client = SecretManagerServiceClient.create((SecretManagerServiceSettings)settings);
        } else if (this.useDefaultInstance && ObjectHelper.isNotEmpty((String)this.projectId)) {
            SecretManagerServiceSettings settings = SecretManagerServiceSettings.newBuilder().build();
            this.client = SecretManagerServiceClient.create((SecretManagerServiceSettings)settings);
        } else {
            throw new RuntimeCamelException("Using the GCP Secret Manager Properties Function requires setting GCP service account key and project Id as application properties or environment variables");
        }
    }

    protected void doStop() throws Exception {
        if (this.client != null) {
            this.client.close();
        }
        this.secrets.clear();
        super.doStop();
    }

    public String getName() {
        return "gcp";
    }

    public String apply(String remainder) {
        String key = remainder;
        String subkey = null;
        String returnValue = null;
        String defaultValue = null;
        String version = null;
        if (remainder.contains("#")) {
            key = StringHelper.before((String)remainder, (String)"#");
            subkey = StringHelper.after((String)remainder, (String)"#");
            defaultValue = StringHelper.after((String)subkey, (String)":");
            if (ObjectHelper.isNotEmpty((String)defaultValue) && defaultValue.contains("@")) {
                version = StringHelper.after((String)defaultValue, (String)"@");
                defaultValue = StringHelper.before((String)defaultValue, (String)"@");
            }
            if (subkey.contains(":")) {
                subkey = StringHelper.before((String)subkey, (String)":");
            }
            if (subkey.contains("@")) {
                version = StringHelper.after((String)subkey, (String)"@");
                subkey = StringHelper.before((String)subkey, (String)"@");
            }
        } else if (remainder.contains(":")) {
            key = StringHelper.before((String)remainder, (String)":");
            defaultValue = StringHelper.after((String)remainder, (String)":");
            if (remainder.contains("@")) {
                version = StringHelper.after((String)remainder, (String)"@");
                defaultValue = StringHelper.before((String)defaultValue, (String)"@");
            }
        } else if (remainder.contains("@")) {
            key = StringHelper.before((String)remainder, (String)"@");
            version = StringHelper.after((String)remainder, (String)"@");
        }
        if (key != null) {
            try {
                returnValue = this.getSecretFromSource(key, subkey, defaultValue, version);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeCamelException("Something went wrong while recovering " + key + " from vault");
            }
        }
        return returnValue;
    }

    private String getSecretFromSource(String key, String subkey, String defaultValue, String version) throws JsonProcessingException {
        this.secrets.add(key);
        String returnValue = null;
        try {
            SecretVersionName secretVersionName = SecretVersionName.of((String)this.projectId, (String)key, (String)(ObjectHelper.isNotEmpty((String)version) ? version : "latest"));
            AccessSecretVersionResponse response = this.client.accessSecretVersion(secretVersionName);
            if (ObjectHelper.isNotEmpty((Object)response)) {
                returnValue = response.getPayload().getData().toStringUtf8();
            }
            if (ObjectHelper.isNotEmpty((String)subkey) && ObjectHelper.isNotEmpty((String)returnValue)) {
                ObjectMapper mapper = new ObjectMapper();
                JsonNode actualObj = mapper.readTree(returnValue);
                JsonNode field = actualObj.get(subkey);
                returnValue = ObjectHelper.isNotEmpty((Object)field) ? field.textValue() : null;
            }
            if (ObjectHelper.isEmpty((String)returnValue)) {
                returnValue = defaultValue;
            }
        }
        catch (ApiException ex) {
            if (ObjectHelper.isNotEmpty((String)defaultValue)) {
                returnValue = defaultValue;
            }
            throw ex;
        }
        return returnValue;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public Set<String> getSecrets() {
        return this.secrets;
    }

    public boolean isUseDefaultInstance() {
        return this.useDefaultInstance;
    }
}

