/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.pubsub;

import com.google.api.core.AbstractApiService;
import com.google.api.core.ApiFuture;
import com.google.cloud.pubsub.v1.Subscriber;
import com.google.cloud.pubsub.v1.stub.SubscriberStub;
import com.google.common.base.Strings;
import com.google.pubsub.v1.ProjectSubscriptionName;
import com.google.pubsub.v1.PullResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.google.pubsub.GooglePubsubEndpoint;
import org.apache.camel.component.google.pubsub.consumer.CamelMessageReceiver;
import org.apache.camel.support.DefaultConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GooglePubsubConsumer
extends DefaultConsumer {
    private final Logger localLog;
    private final GooglePubsubEndpoint endpoint;
    private final Processor processor;
    private ExecutorService executor;
    private final List<Subscriber> subscribers;
    private final Set<ApiFuture<PullResponse>> pendingSynchronousPullResponses;

    GooglePubsubConsumer(GooglePubsubEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.processor = processor;
        this.subscribers = Collections.synchronizedList(new LinkedList());
        this.pendingSynchronousPullResponses = ConcurrentHashMap.newKeySet();
        String loggerId = endpoint.getLoggerId();
        if (Strings.isNullOrEmpty((String)loggerId)) {
            loggerId = ((Object)((Object)this)).getClass().getName();
        }
        this.localLog = LoggerFactory.getLogger((String)loggerId);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.localLog.info("Starting Google PubSub consumer for {}/{}", (Object)this.endpoint.getProjectId(), (Object)this.endpoint.getDestinationName());
        this.executor = this.endpoint.createExecutor((Object)this);
        for (int i = 0; i < this.endpoint.getConcurrentConsumers(); ++i) {
            this.executor.submit(new SubscriberWrapper());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        this.localLog.info("Stopping Google PubSub consumer for {}/{}", (Object)this.endpoint.getProjectId(), (Object)this.endpoint.getDestinationName());
        List<Subscriber> list = this.subscribers;
        synchronized (list) {
            if (!this.subscribers.isEmpty()) {
                this.localLog.info("Stopping subscribers for {}/{}", (Object)this.endpoint.getProjectId(), (Object)this.endpoint.getDestinationName());
                this.subscribers.forEach(AbstractApiService::stopAsync);
            }
        }
        this.safeCancelSynchronousPullResponses();
        if (this.executor != null) {
            if (this.getEndpoint() != null && this.getEndpoint().getCamelContext() != null) {
                this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownGraceful(this.executor);
            } else {
                this.executor.shutdownNow();
            }
        }
        this.executor = null;
        super.doStop();
    }

    private void safeCancelSynchronousPullResponses() {
        for (ApiFuture<PullResponse> pullResponseApiFuture : this.pendingSynchronousPullResponses) {
            try {
                pullResponseApiFuture.cancel(true);
            }
            catch (Exception e) {
                this.localLog.warn("Exception while cancelling pending synchronous pull response", (Throwable)e);
            }
        }
        this.pendingSynchronousPullResponses.clear();
    }

    private class SubscriberWrapper
    implements Runnable {
        private final String subscriptionName;

        SubscriberWrapper() {
            this.subscriptionName = ProjectSubscriptionName.format((String)GooglePubsubConsumer.this.endpoint.getProjectId(), (String)GooglePubsubConsumer.this.endpoint.getDestinationName());
        }

        @Override
        public void run() {
            try {
                if (GooglePubsubConsumer.this.localLog.isDebugEnabled()) {
                    GooglePubsubConsumer.this.localLog.debug("Subscribing to {}", (Object)this.subscriptionName);
                }
                if (GooglePubsubConsumer.this.endpoint.isSynchronousPull()) {
                    this.synchronousPull(this.subscriptionName);
                } else {
                    this.asynchronousPull(this.subscriptionName);
                }
                GooglePubsubConsumer.this.localLog.debug("Exit run for subscription {}", (Object)this.subscriptionName);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                GooglePubsubConsumer.this.localLog.error("Failure getting messages from PubSub", (Throwable)e);
            }
            catch (Exception e) {
                GooglePubsubConsumer.this.localLog.error("Failure getting messages from PubSub", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void asynchronousPull(String subscriptionName) throws IOException {
            while (GooglePubsubConsumer.this.isRunAllowed() && !GooglePubsubConsumer.this.isSuspendingOrSuspended()) {
                CamelMessageReceiver messageReceiver = new CamelMessageReceiver(GooglePubsubConsumer.this, GooglePubsubConsumer.this.endpoint, GooglePubsubConsumer.this.processor);
                Subscriber subscriber = GooglePubsubConsumer.this.endpoint.getComponent().getSubscriber(subscriptionName, messageReceiver, GooglePubsubConsumer.this.endpoint);
                try {
                    GooglePubsubConsumer.this.subscribers.add(subscriber);
                    subscriber.startAsync().awaitRunning();
                    subscriber.awaitTerminated();
                }
                catch (Exception e) {
                    GooglePubsubConsumer.this.localLog.error("Failure getting messages from PubSub", (Throwable)e);
                }
                finally {
                    GooglePubsubConsumer.this.localLog.debug("Stopping async subscriber {}", (Object)subscriptionName);
                    subscriber.stopAsync();
                }
            }
        }

        /*
         * Exception decompiling
         */
        private void synchronousPull(String subscriptionName) throws ExecutionException, InterruptedException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private /* synthetic */ SubscriberStub lambda$synchronousPull$0() throws Exception {
            return GooglePubsubConsumer.this.endpoint.getComponent().getSubscriberStub(GooglePubsubConsumer.this.endpoint);
        }
    }
}

