/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.mail;

import java.util.Collection;
import java.util.List;
import org.apache.camel.component.google.mail.internal.GoogleMailApiName;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;

@UriParams
@Configurer(extended=true)
public class GoogleMailConfiguration {
    @UriPath
    @Metadata(required=true)
    private GoogleMailApiName apiName;
    @UriPath(enums="attachments,create,delete,get,getProfile,gmailImport,insert,list,modify,patch,send,stop,trash,untrash,update,watch")
    @Metadata(required=true)
    private String methodName;
    @UriParam
    private String clientId;
    @UriParam(label="security", secret=true)
    private String clientSecret;
    @UriParam(label="security", secret=true)
    private String accessToken;
    @UriParam(label="security", secret=true)
    private String refreshToken;
    @UriParam
    private String applicationName;
    @UriParam(label="security")
    private String serviceAccountKey;
    @UriParam
    private String delegate;
    @UriParam
    private String scopes;

    public GoogleMailApiName getApiName() {
        return this.apiName;
    }

    public void setApiName(GoogleMailApiName apiName) {
        this.apiName = apiName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getServiceAccountKey() {
        return this.serviceAccountKey;
    }

    public void setServiceAccountKey(String serviceAccountKey) {
        this.serviceAccountKey = serviceAccountKey;
    }

    public String getDelegate() {
        return this.delegate;
    }

    public void setDelegate(String delegate) {
        this.delegate = delegate;
    }

    public String getScopes() {
        return this.scopes;
    }

    public Collection<String> getScopesAsList() {
        if (this.scopes != null) {
            return List.of(this.scopes.split(","));
        }
        return null;
    }

    public void setScopes(String scopes) {
        this.scopes = scopes;
    }
}

