/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.functions;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.functions.v1.CloudFunctionsServiceClient;
import com.google.cloud.functions.v1.CloudFunctionsServiceSettings;
import com.google.common.base.Strings;
import java.io.InputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.component.google.functions.GoogleCloudFunctionsConfiguration;
import org.apache.camel.support.ResourceHelper;

public final class GoogleCloudFunctionsClientFactory {
    private GoogleCloudFunctionsClientFactory() {
    }

    public static CloudFunctionsServiceClient create(CamelContext context, GoogleCloudFunctionsConfiguration configuration) throws Exception {
        CloudFunctionsServiceClient cloudFunctionsClient = null;
        if (!Strings.isNullOrEmpty((String)configuration.getServiceAccountKey())) {
            InputStream resolveMandatoryResourceAsInputStream = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)context, (String)configuration.getServiceAccountKey());
            ServiceAccountCredentials myCredentials = ServiceAccountCredentials.fromStream((InputStream)resolveMandatoryResourceAsInputStream);
            CloudFunctionsServiceSettings settings = ((CloudFunctionsServiceSettings.Builder)CloudFunctionsServiceSettings.newBuilder().setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)myCredentials))).build();
            cloudFunctionsClient = CloudFunctionsServiceClient.create((CloudFunctionsServiceSettings)settings);
        } else {
            CloudFunctionsServiceSettings settings = CloudFunctionsServiceSettings.newBuilder().build();
            cloudFunctionsClient = CloudFunctionsServiceClient.create((CloudFunctionsServiceSettings)settings);
        }
        return cloudFunctionsClient;
    }
}

