/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.drive;

import com.google.api.services.drive.Drive;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.google.drive.BatchGoogleDriveClientFactory;
import org.apache.camel.component.google.drive.GoogleDriveClientFactory;
import org.apache.camel.component.google.drive.GoogleDriveConfiguration;
import org.apache.camel.component.google.drive.GoogleDriveEndpoint;
import org.apache.camel.component.google.drive.internal.GoogleDriveApiCollection;
import org.apache.camel.component.google.drive.internal.GoogleDriveApiName;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.component.AbstractApiComponent;
import org.apache.camel.support.component.ApiCollection;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(value="google-drive")
public class GoogleDriveComponent
extends AbstractApiComponent<GoogleDriveApiName, GoogleDriveConfiguration, GoogleDriveApiCollection> {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleDriveComponent.class);
    @Metadata
    GoogleDriveConfiguration configuration;
    @Metadata(label="advanced")
    private Drive client;
    @Metadata(label="advanced")
    private GoogleDriveClientFactory clientFactory;
    @Metadata(label="proxy", description="Proxy server host")
    private String proxyHost;
    @Metadata(label="proxy", description="Proxy server port")
    private Integer proxyPort;

    public GoogleDriveComponent() {
        super(GoogleDriveApiName.class, (ApiCollection)GoogleDriveApiCollection.getCollection());
    }

    public GoogleDriveComponent(CamelContext context) {
        super(context, GoogleDriveApiName.class, (ApiCollection)GoogleDriveApiCollection.getCollection());
    }

    protected GoogleDriveApiName getApiName(String apiNameStr) {
        return (GoogleDriveApiName)((Object)this.getCamelContext().getTypeConverter().convertTo(GoogleDriveApiName.class, (Object)apiNameStr));
    }

    public Drive getClient(GoogleDriveConfiguration config) {
        if (this.client == null) {
            if (config.getClientId() != null && !config.getClientId().isBlank() && config.getClientSecret() != null && !config.getClientSecret().isBlank()) {
                this.client = this.getClientFactory().makeClient(config.getClientId(), config.getClientSecret(), config.getScopesAsList(), config.getApplicationName(), config.getRefreshToken(), config.getAccessToken());
            } else if (config.getServiceAccountKey() != null && !config.getServiceAccountKey().isBlank()) {
                this.client = this.getClientFactory().makeClient(this.getCamelContext(), config.getServiceAccountKey(), config.getScopesAsList(), config.getApplicationName(), config.getDelegate());
            } else {
                throw new IllegalArgumentException("(clientId and clientSecret) or serviceAccountKey are required to create Google Drive client");
            }
        }
        return this.client;
    }

    public GoogleDriveClientFactory getClientFactory() {
        if (this.clientFactory == null) {
            if (ObjectHelper.isNotEmpty((String)this.getCamelContext().getGlobalOption("http.proxyHost")) && ObjectHelper.isNotEmpty((String)this.getCamelContext().getGlobalOption("http.proxyPort"))) {
                String host = this.getCamelContext().getGlobalOption("http.proxyHost");
                int port = Integer.parseInt(this.getCamelContext().getGlobalOption("http.proxyPort"));
                LOG.warn("CamelContext global options [http.proxyHost,http.proxyPort] detected. Using global option configuration is deprecated. Instead configure this on the component. Using http proxy host: {} port: {}", (Object)host, (Object)port);
                this.clientFactory = new BatchGoogleDriveClientFactory(host, port);
            } else {
                this.clientFactory = this.proxyHost != null && this.proxyPort != null ? new BatchGoogleDriveClientFactory(this.proxyHost, this.proxyPort) : new BatchGoogleDriveClientFactory();
            }
        }
        return this.clientFactory;
    }

    public void setConfiguration(GoogleDriveConfiguration configuration) {
        super.setConfiguration((Object)configuration);
    }

    public GoogleDriveConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new GoogleDriveConfiguration();
        }
        return (GoogleDriveConfiguration)super.getConfiguration();
    }

    public void setClientFactory(GoogleDriveClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    protected Endpoint createEndpoint(String uri, String methodName, GoogleDriveApiName apiName, GoogleDriveConfiguration endpointConfiguration) {
        endpointConfiguration.setApiName(apiName);
        endpointConfiguration.setMethodName(methodName);
        GoogleDriveEndpoint endpoint = new GoogleDriveEndpoint(uri, this, apiName, methodName, endpointConfiguration);
        endpoint.setClientFactory(this.clientFactory);
        return endpoint;
    }
}

