/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.drive;

import com.google.api.services.drive.model.Channel;
import org.apache.camel.component.google.drive.GoogleDriveConfiguration;
import org.apache.camel.spi.ApiMethod;
import org.apache.camel.spi.ApiParam;
import org.apache.camel.spi.ApiParams;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

@ApiParams(apiName="drive-changes", description="The changes collection of methods", apiMethods={@ApiMethod(methodName="getStartPageToken", description="Gets the starting pageToken for listing future changes", signatures={"com.google.api.services.drive.Drive$Changes$GetStartPageToken getStartPageToken()"}), @ApiMethod(methodName="list", description="Lists the changes for a user or shared drive", signatures={"com.google.api.services.drive.Drive$Changes$List list(String pageToken)"}), @ApiMethod(methodName="watch", description="Subscribes to changes for a user", signatures={"com.google.api.services.drive.Drive$Changes$Watch watch(String pageToken, com.google.api.services.drive.model.Channel content)"})}, aliases={})
@UriParams
@Configurer(extended=true)
public final class DriveChangesEndpointConfiguration
extends GoogleDriveConfiguration {
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="watch", description="The com.google.api.services.drive.model.Channel")})
    private Channel contentChannel;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="getStartPageToken", description="The ID of the shared drive for which the starting pageToken for listing future changes from that shared drive will be returned"), @ApiMethod(methodName="list", description="The shared drive from which changes will be returned"), @ApiMethod(methodName="watch", description="The shared drive from which changes will be returned")})
    private String driveId;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="list", description="Whether changes should include the file resource if the file is still accessible by the user at the time of the request, even when a file was removed from the list of changes and there will be no further change entries for this file"), @ApiMethod(methodName="watch", description="Whether changes should include the file resource if the file is still accessible by the user at the time of the request, even when a file was removed from the list of changes and there will be no further change entries for this file")})
    private Boolean includeCorpusRemovals;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="list", description="Whether both My Drive and shared drive items should be included in results"), @ApiMethod(methodName="watch", description="Whether both My Drive and shared drive items should be included in results")})
    private Boolean includeItemsFromAllDrives;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="list", description="A comma-separated list of IDs of labels to include in the labelInfo part of the response"), @ApiMethod(methodName="watch", description="A comma-separated list of IDs of labels to include in the labelInfo part of the response")})
    private String includeLabels;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="list", description="Specifies which additional view's permissions to include in the response"), @ApiMethod(methodName="watch", description="Specifies which additional view's permissions to include in the response")})
    private String includePermissionsForView;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="list", description="Whether to include changes indicating that items have been removed from the list of changes, for example by deletion or loss of access"), @ApiMethod(methodName="watch", description="Whether to include changes indicating that items have been removed from the list of changes, for example by deletion or loss of access")})
    private Boolean includeRemoved;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="list", description="Deprecated: Use includeItemsFromAllDrives instead"), @ApiMethod(methodName="watch", description="Deprecated: Use includeItemsFromAllDrives instead")})
    @Deprecated
    private Boolean includeTeamDriveItems;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="list", description="The maximum number of changes to return per page"), @ApiMethod(methodName="watch", description="The maximum number of changes to return per page")})
    private Integer pageSize;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="list", description="The token for continuing a previous list request on the next page. This should be set to the value of 'nextPageToken' from the previous response or to the response from the getStartPageToken method."), @ApiMethod(methodName="watch", description="The token for continuing a previous list request on the next page. This should be set to the value of 'nextPageToken' from the previous response or to the response from the getStartPageToken method.")})
    private String pageToken;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="list", description="Whether to restrict the results to changes inside the My Drive hierarchy"), @ApiMethod(methodName="watch", description="Whether to restrict the results to changes inside the My Drive hierarchy")})
    private Boolean restrictToMyDrive;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="list", description="A comma-separated list of spaces to query within the corpora"), @ApiMethod(methodName="watch", description="A comma-separated list of spaces to query within the corpora")})
    private String spaces;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="getStartPageToken", description="Whether the requesting application supports both My Drives and shared drives"), @ApiMethod(methodName="list", description="Whether the requesting application supports both My Drives and shared drives"), @ApiMethod(methodName="watch", description="Whether the requesting application supports both My Drives and shared drives")})
    private Boolean supportsAllDrives;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="getStartPageToken", description="Deprecated: Use supportsAllDrives instead"), @ApiMethod(methodName="list", description="Deprecated: Use supportsAllDrives instead"), @ApiMethod(methodName="watch", description="Deprecated: Use supportsAllDrives instead")})
    @Deprecated
    private Boolean supportsTeamDrives;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="getStartPageToken", description="Deprecated: Use driveId instead"), @ApiMethod(methodName="list", description="Deprecated: Use driveId instead"), @ApiMethod(methodName="watch", description="Deprecated: Use driveId instead")})
    @Deprecated
    private String teamDriveId;

    public Channel getContentChannel() {
        return this.contentChannel;
    }

    public void setContentChannel(Channel contentChannel) {
        this.contentChannel = contentChannel;
    }

    public String getDriveId() {
        return this.driveId;
    }

    public void setDriveId(String driveId) {
        this.driveId = driveId;
    }

    public Boolean getIncludeCorpusRemovals() {
        return this.includeCorpusRemovals;
    }

    public void setIncludeCorpusRemovals(Boolean includeCorpusRemovals) {
        this.includeCorpusRemovals = includeCorpusRemovals;
    }

    public Boolean getIncludeItemsFromAllDrives() {
        return this.includeItemsFromAllDrives;
    }

    public void setIncludeItemsFromAllDrives(Boolean includeItemsFromAllDrives) {
        this.includeItemsFromAllDrives = includeItemsFromAllDrives;
    }

    public String getIncludeLabels() {
        return this.includeLabels;
    }

    public void setIncludeLabels(String includeLabels) {
        this.includeLabels = includeLabels;
    }

    public String getIncludePermissionsForView() {
        return this.includePermissionsForView;
    }

    public void setIncludePermissionsForView(String includePermissionsForView) {
        this.includePermissionsForView = includePermissionsForView;
    }

    public Boolean getIncludeRemoved() {
        return this.includeRemoved;
    }

    public void setIncludeRemoved(Boolean includeRemoved) {
        this.includeRemoved = includeRemoved;
    }

    public Boolean getIncludeTeamDriveItems() {
        return this.includeTeamDriveItems;
    }

    public void setIncludeTeamDriveItems(Boolean includeTeamDriveItems) {
        this.includeTeamDriveItems = includeTeamDriveItems;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getPageToken() {
        return this.pageToken;
    }

    public void setPageToken(String pageToken) {
        this.pageToken = pageToken;
    }

    public Boolean getRestrictToMyDrive() {
        return this.restrictToMyDrive;
    }

    public void setRestrictToMyDrive(Boolean restrictToMyDrive) {
        this.restrictToMyDrive = restrictToMyDrive;
    }

    public String getSpaces() {
        return this.spaces;
    }

    public void setSpaces(String spaces) {
        this.spaces = spaces;
    }

    public Boolean getSupportsAllDrives() {
        return this.supportsAllDrives;
    }

    public void setSupportsAllDrives(Boolean supportsAllDrives) {
        this.supportsAllDrives = supportsAllDrives;
    }

    public Boolean getSupportsTeamDrives() {
        return this.supportsTeamDrives;
    }

    public void setSupportsTeamDrives(Boolean supportsTeamDrives) {
        this.supportsTeamDrives = supportsTeamDrives;
    }

    public String getTeamDriveId() {
        return this.teamDriveId;
    }

    public void setTeamDriveId(String teamDriveId) {
        this.teamDriveId = teamDriveId;
    }
}

