/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.drive;

import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.services.drive.model.Channel;
import com.google.api.services.drive.model.File;
import com.google.api.services.drive.model.ModifyLabelsRequest;
import org.apache.camel.component.google.drive.GoogleDriveConfiguration;
import org.apache.camel.spi.ApiMethod;
import org.apache.camel.spi.ApiParam;
import org.apache.camel.spi.ApiParams;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

@ApiParams(apiName="drive-files", description="The files collection of methods", apiMethods={@ApiMethod(methodName="copy", description="Creates a copy of a file and applies any requested updates with patch semantics", signatures={"com.google.api.services.drive.Drive$Files$Copy copy(String fileId, com.google.api.services.drive.model.File content)"}), @ApiMethod(methodName="create", description="Creates a new file", signatures={"com.google.api.services.drive.Drive$Files$Create create(com.google.api.services.drive.model.File content)", "com.google.api.services.drive.Drive$Files$Create create(com.google.api.services.drive.model.File content, com.google.api.client.http.AbstractInputStreamContent mediaContent)"}), @ApiMethod(methodName="delete", description="Permanently deletes a file owned by the user without moving it to the trash", signatures={"com.google.api.services.drive.Drive$Files$Delete delete(String fileId)"}), @ApiMethod(methodName="download", description="Downloads content of a file", signatures={"com.google.api.services.drive.Drive$Files$Download download(String fileId)"}), @ApiMethod(methodName="emptyTrash", description="Permanently deletes all of the user's trashed files", signatures={"com.google.api.services.drive.Drive$Files$EmptyTrash emptyTrash()"}), @ApiMethod(methodName="export", description="Exports a Google Workspace document to the requested MIME type and returns exported byte content", signatures={"com.google.api.services.drive.Drive$Files$Export export(String fileId, String mimeType)"}), @ApiMethod(methodName="generateIds", description="Generates a set of file IDs which can be provided in create or copy requests", signatures={"com.google.api.services.drive.Drive$Files$GenerateIds generateIds()"}), @ApiMethod(methodName="get", description="Gets a file's metadata or content by ID", signatures={"com.google.api.services.drive.Drive$Files$Get get(String fileId)"}), @ApiMethod(methodName="list", description="Lists the user's files", signatures={"com.google.api.services.drive.Drive$Files$List list()"}), @ApiMethod(methodName="listLabels", description="Lists the labels on a file", signatures={"com.google.api.services.drive.Drive$Files$ListLabels listLabels(String fileId)"}), @ApiMethod(methodName="modifyLabels", description="Modifies the set of labels applied to a file", signatures={"com.google.api.services.drive.Drive$Files$ModifyLabels modifyLabels(String fileId, com.google.api.services.drive.model.ModifyLabelsRequest content)"}), @ApiMethod(methodName="update", description="Updates a file's metadata and/or content", signatures={"com.google.api.services.drive.Drive$Files$Update update(String fileId, com.google.api.services.drive.model.File content)", "com.google.api.services.drive.Drive$Files$Update update(String fileId, com.google.api.services.drive.model.File content, com.google.api.client.http.AbstractInputStreamContent mediaContent)"}), @ApiMethod(methodName="watch", description="Subscribes to changes to a file", signatures={"com.google.api.services.drive.Drive$Files$Watch watch(String fileId, com.google.api.services.drive.model.Channel content)"})}, aliases={})
@UriParams
@Configurer(extended=true)
public final class DriveFilesEndpointConfiguration
extends GoogleDriveConfiguration {
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="watch", description="The com.google.api.services.drive.model.Channel")})
    private Channel channel;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="create", description="The com.google.api.services.drive.model.File media metadata or null if none")})
    private File content;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="copy", description="The com.google.api.services.drive.model.File"), @ApiMethod(methodName="update", description="The com.google.api.services.drive.model.File media metadata or null if none")})
    private File file;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="copy", description="The ID of the file"), @ApiMethod(methodName="delete", description="The ID of the file"), @ApiMethod(methodName="download", description="Required. The ID of the file to download."), @ApiMethod(methodName="export", description="The ID of the file"), @ApiMethod(methodName="get", description="The ID of the file"), @ApiMethod(methodName="listLabels", description="The ID for the file"), @ApiMethod(methodName="modifyLabels", description="The ID of the file to which the labels belong"), @ApiMethod(methodName="update", description="The ID of the file"), @ApiMethod(methodName="watch", description="The ID of the file")})
    private String fileId;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="create", description="The media HTTP content"), @ApiMethod(methodName="update", description="The media HTTP content")})
    private AbstractInputStreamContent mediaContent;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="export", description="Required. The MIME type of the format requested for this export.")})
    private String mimeType;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="modifyLabels", description="The com.google.api.services.drive.model.ModifyLabelsRequest")})
    private ModifyLabelsRequest modifyLabelsRequest;

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public File getContent() {
        return this.content;
    }

    public void setContent(File content) {
        this.content = content;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getFileId() {
        return this.fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public AbstractInputStreamContent getMediaContent() {
        return this.mediaContent;
    }

    public void setMediaContent(AbstractInputStreamContent mediaContent) {
        this.mediaContent = mediaContent;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public ModifyLabelsRequest getModifyLabelsRequest() {
        return this.modifyLabelsRequest;
    }

    public void setModifyLabelsRequest(ModifyLabelsRequest modifyLabelsRequest) {
        this.modifyLabelsRequest = modifyLabelsRequest;
    }
}

