/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.calendar;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class GoogleCalendarEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":apiName/methodName";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "google-calendar".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "apiName", null, true, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "methodName", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(68);
        props.add("accessToken");
        props.add("alwaysIncludeEmail");
        props.add("apiName");
        props.add("applicationName");
        props.add("backoffErrorThreshold");
        props.add("backoffIdleThreshold");
        props.add("backoffMultiplier");
        props.add("bridgeErrorHandler");
        props.add("calendarId");
        props.add("clientId");
        props.add("clientSecret");
        props.add("colorRgbFormat");
        props.add("conferenceDataVersion");
        props.add("content");
        props.add("contentChannel");
        props.add("delay");
        props.add("delegate");
        props.add("destination");
        props.add("emailAddress");
        props.add("eventId");
        props.add("eventTypes");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("greedy");
        props.add("iCalUID");
        props.add("inBody");
        props.add("initialDelay");
        props.add("lazyStartProducer");
        props.add("maxAttendees");
        props.add("maxResults");
        props.add("methodName");
        props.add("minAccessRole");
        props.add("orderBy");
        props.add("originalStart");
        props.add("p12FileName");
        props.add("pageToken");
        props.add("pollStrategy");
        props.add("privateExtendedProperty");
        props.add("q");
        props.add("refreshToken");
        props.add("repeatCount");
        props.add("ruleId");
        props.add("runLoggingLevel");
        props.add("scheduledExecutorService");
        props.add("scheduler");
        props.add("schedulerProperties");
        props.add("scopes");
        props.add("sendEmptyMessageWhenIdle");
        props.add("sendNotifications");
        props.add("sendUpdates");
        props.add("serviceAccountKey");
        props.add("setting");
        props.add("sharedExtendedProperty");
        props.add("showDeleted");
        props.add("showHidden");
        props.add("showHiddenInvitations");
        props.add("singleEvents");
        props.add("startScheduler");
        props.add("supportsAttachments");
        props.add("syncToken");
        props.add("text");
        props.add("timeMax");
        props.add("timeMin");
        props.add("timeUnit");
        props.add("timeZone");
        props.add("updatedMin");
        props.add("useFixedDelay");
        props.add("user");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(6);
        secretProps.add("accessToken");
        secretProps.add("clientSecret");
        secretProps.add("emailAddress");
        secretProps.add("p12FileName");
        secretProps.add("refreshToken");
        secretProps.add("user");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
        HashSet<String> prefixes = new HashSet<String>(1);
        prefixes.add("scheduler.");
        MULTI_VALUE_PREFIXES = Collections.unmodifiableSet(prefixes);
    }
}

