/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.bigquery.sql;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.support.ResourceHelper;

public final class SqlHelper {
    private static Pattern pattern = Pattern.compile("\\$\\{(\\w+)}");
    private static Pattern parameterPattern = Pattern.compile("@(\\w+)");

    private SqlHelper() {
    }

    public static String resolveQuery(CamelContext camelContext, String query, String placeholder) throws NoTypeConversionAvailableException, IOException {
        String answer = query;
        if (ResourceHelper.hasScheme((String)query)) {
            try (InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)camelContext, (String)query);){
                answer = (String)camelContext.getTypeConverter().mandatoryConvertTo(String.class, (Object)is);
                if (placeholder != null) {
                    answer = answer.replaceAll(placeholder, "@");
                }
            }
        }
        return answer;
    }

    public static String translateQuery(String query, Exchange exchange) {
        Message message = exchange.getMessage();
        Matcher matcher = pattern.matcher(query);
        StringBuilder stringBuffer = new StringBuilder();
        while (matcher.find()) {
            String paramKey = matcher.group(1);
            String value = (String)message.getHeader(paramKey, String.class);
            if (value == null && (value = (String)exchange.getProperty(paramKey, String.class)) == null) {
                throw new RuntimeExchangeException("SQL pattern with name '" + paramKey + "' not found in the message headers", exchange);
            }
            String replacement = Matcher.quoteReplacement(value);
            matcher.appendReplacement(stringBuffer, replacement);
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public static Set<String> extractParameterNames(String query) {
        Matcher matcher = parameterPattern.matcher(query);
        HashSet<String> result = new HashSet<String>();
        while (matcher.find()) {
            String paramName = matcher.group(1);
            result.add(paramName);
        }
        return result;
    }
}

