/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.git;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class GitEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":localPath";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Map<String, String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "git".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "localPath", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Map<String, String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(32);
        props.add("allowEmpty");
        props.add("backoffErrorThreshold");
        props.add("backoffIdleThreshold");
        props.add("backoffMultiplier");
        props.add("branchName");
        props.add("bridgeErrorHandler");
        props.add("delay");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("gitConfigFile");
        props.add("greedy");
        props.add("initialDelay");
        props.add("lazyStartProducer");
        props.add("localPath");
        props.add("operation");
        props.add("password");
        props.add("pollStrategy");
        props.add("remoteName");
        props.add("remotePath");
        props.add("repeatCount");
        props.add("runLoggingLevel");
        props.add("scheduledExecutorService");
        props.add("scheduler");
        props.add("schedulerProperties");
        props.add("sendEmptyMessageWhenIdle");
        props.add("startScheduler");
        props.add("tagName");
        props.add("targetBranchName");
        props.add("timeUnit");
        props.add("type");
        props.add("useFixedDelay");
        props.add("username");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(2);
        secretProps.add("password");
        secretProps.add("username");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
        HashMap<String, String> prefixes = new HashMap<String, String>(1);
        prefixes.put("schedulerProperties", "scheduler.");
        MULTI_VALUE_PREFIXES = Collections.unmodifiableMap(prefixes);
    }
}

