/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import org.apache.camel.component.file.remote.FtpClientActivityListener;
import org.apache.camel.component.file.remote.FtpEndpoint;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.commons.net.io.CopyStreamEvent;
import org.apache.commons.net.io.CopyStreamListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFtpClientActivityListener
implements FtpClientActivityListener,
CopyStreamListener {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultFtpClientActivityListener.class);
    private final CamelLogger logger;
    private final String host;
    private final FtpEndpoint endpoint;
    private boolean download = true;
    private boolean resume;
    private long resumeOffset;
    private String fileName;
    private long fileSize;
    private String fileSizeText;
    private String lastLogActivity;
    private String lastVerboseLogActivity;
    private long lastLogActivityTimestamp = -1L;
    private long lastVerboseLogActivityTimestamp = -1L;
    private long transferredBytes;
    private final StopWatch watch = new StopWatch();
    private final StopWatch interval = new StopWatch();

    public DefaultFtpClientActivityListener(FtpEndpoint endpoint, String host) {
        this.logger = new CamelLogger(LOG);
        this.endpoint = endpoint;
        this.host = host;
    }

    @Override
    public void setDownload(boolean download) {
        this.download = download;
    }

    @Override
    public void setRemoteFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public void setRemoteFileSize(long fileSize) {
        this.fileSize = fileSize;
        this.fileSizeText = StringHelper.humanReadableBytes((long)fileSize);
    }

    @Override
    public String getLastLogActivity() {
        return this.lastLogActivity;
    }

    @Override
    public long getLastLogActivityTimestamp() {
        return this.lastLogActivityTimestamp;
    }

    @Override
    public String getLastVerboseLogActivity() {
        return this.lastVerboseLogActivity;
    }

    @Override
    public long getLastVerboseLogActivityTimestamp() {
        return this.lastVerboseLogActivityTimestamp;
    }

    @Override
    public void onGeneralError(String host, String errorMessage) {
        this.doLogVerbose("General error when communicating with host: " + host + " error: " + errorMessage);
    }

    @Override
    public void onConnecting(String host) {
        this.doLogVerbose("Connecting to host: " + host);
    }

    @Override
    public void onConnected(String host) {
        this.doLogVerbose("Connected to host: " + host);
    }

    @Override
    public void onLogin(String host) {
        this.doLogVerbose("Login on host: " + host);
    }

    @Override
    public void onLoginComplete(String host) {
        this.doLogVerbose("Login on host: " + host + " complete");
    }

    @Override
    public void onLoginFailed(int replyCode, String replyMessage) {
        this.doLogVerbose("Login on host: " + this.host + " failed (code: " + replyCode + ", message: " + replyMessage + ")");
    }

    @Override
    public void onDisconnecting(String host) {
        this.doLogVerbose("Disconnecting from host: " + host);
    }

    @Override
    public void onDisconnected(String host) {
        this.doLogVerbose("Disconnected from host: " + host);
    }

    @Override
    public void onScanningForFiles(String host, String directory) {
        if (ObjectHelper.isEmpty((String)directory)) {
            this.doLogVerbose("Scanning for new files to download from host: " + host);
        } else {
            this.doLogVerbose("Scanning for new files to download from host: " + host + " in directory: " + directory);
        }
    }

    @Override
    public void onBeginDownloading(String host, String file) {
        this.download = true;
        this.resume = false;
        this.resumeOffset = 0L;
        this.watch.restart();
        this.interval.restart();
        String msg = "Downloading from host: " + host + " file: " + file + " starting ";
        if (this.fileSize > 0L) {
            msg = msg + " (size: " + this.fileSizeText + ")";
        }
        this.doLog(msg);
    }

    @Override
    public void onResumeDownloading(String host, String file, long position) {
        this.download = true;
        this.resume = true;
        this.resumeOffset = position;
        this.watch.restart();
        this.interval.restart();
        String msg = "Resume downloading from host: " + host + " file: " + file + " at position: " + position + " bytes/" + StringHelper.humanReadableBytes((long)position);
        if (this.fileSize > 0L) {
            float percent = (float)this.resumeOffset / (float)this.fileSize * 100.0f;
            String num = String.format("%.1f", Float.valueOf(percent));
            msg = msg + "/" + num + "% (size: " + this.fileSizeText + ")";
        }
        this.doLog(msg);
    }

    @Override
    public void onDownload(String host, String file, long chunkSize, long totalChunkSize, long fileSize) {
        this.transferredBytes = totalChunkSize += this.resumeOffset;
        String prefix = this.resume ? "Resume downloading" : "Downloading";
        String msg = prefix + " from host: " + host + " file: " + file + " chunk (" + chunkSize + "/" + totalChunkSize + " bytes)";
        if (fileSize > 0L) {
            float percent = (float)totalChunkSize / (float)fileSize * 100.0f;
            String num = String.format("%.1f", Float.valueOf(percent));
            if (totalChunkSize < fileSize && "100.0".equals(num)) {
                num = "99.9";
            }
            String size = StringHelper.humanReadableBytes((long)totalChunkSize);
            msg = msg + " (progress: " + size + "/" + num + "%)";
        } else {
            String size = StringHelper.humanReadableBytes((long)totalChunkSize);
            msg = msg + " (downloaded: " + size + ")";
        }
        this.doLogVerbose(msg);
        if (this.interval.taken() > (long)(this.endpoint.getTransferLoggingIntervalSeconds() * 1000)) {
            this.doLog(msg);
            this.interval.restart();
        }
    }

    @Override
    public void onDownloadComplete(String host, String file) {
        String prefix = this.resume ? "Resume downloading" : "Downloading";
        String msg = prefix + " from host: " + host + " file: " + file + " completed";
        if (this.transferredBytes > 0L) {
            msg = msg + " (size: " + StringHelper.humanReadableBytes((long)this.transferredBytes) + ")";
        }
        long taken = this.watch.taken();
        String time = TimeUtils.printDuration((long)taken, (boolean)true);
        msg = msg + " (took: " + time + ")";
        this.doLog(msg);
    }

    @Override
    public void onBeginUploading(String host, String file) {
        this.download = false;
        this.watch.restart();
        this.interval.restart();
        String msg = "Uploading to host: " + host + " file: " + file + " starting";
        if (this.fileSize > 0L) {
            msg = msg + " (size: " + this.fileSizeText + ")";
        }
        this.doLog(msg);
    }

    @Override
    public void onUpload(String host, String file, long chunkSize, long totalChunkSize, long fileSize) {
        this.transferredBytes = totalChunkSize;
        String msg = "Uploading to host: " + host + " file: " + file + " chunk (" + chunkSize + "/" + totalChunkSize + " bytes)";
        if (fileSize > 0L) {
            float percent = (float)totalChunkSize / (float)fileSize * 100.0f;
            String num = String.format("%.1f", Float.valueOf(percent));
            if (totalChunkSize < fileSize && "100.0".equals(num)) {
                num = "99.9";
            }
            String size = StringHelper.humanReadableBytes((long)totalChunkSize);
            msg = msg + " (progress: " + size + "/" + num + "%)";
        } else {
            String size = StringHelper.humanReadableBytes((long)totalChunkSize);
            msg = msg + " (uploaded: " + size + ")";
        }
        this.doLogVerbose(msg);
        if (this.interval.taken() > (long)(this.endpoint.getTransferLoggingIntervalSeconds() * 1000)) {
            this.doLog(msg);
            this.interval.restart();
        }
    }

    @Override
    public void onUploadComplete(String host, String file) {
        String msg = "Uploading to host: " + host + " file: " + file + " completed";
        if (this.transferredBytes > 0L) {
            msg = msg + " (size: " + StringHelper.humanReadableBytes((long)this.transferredBytes) + ")";
        }
        long taken = this.watch.taken();
        String time = TimeUtils.printDuration((long)taken, (boolean)true);
        msg = msg + " (took: " + time + ")";
        this.doLog(msg);
    }

    public void bytesTransferred(CopyStreamEvent event) {
    }

    public void bytesTransferred(long totalBytesTransferred, int bytesTransferred, long streamSize) {
        if (this.download) {
            this.onDownload(this.host, this.fileName, bytesTransferred, totalBytesTransferred, this.fileSize);
        } else {
            this.onUpload(this.host, this.fileName, bytesTransferred, totalBytesTransferred, this.fileSize);
        }
    }

    protected void doLog(String message) {
        this.lastLogActivity = message;
        this.lastLogActivityTimestamp = System.currentTimeMillis();
        this.lastVerboseLogActivity = this.lastLogActivity;
        this.lastVerboseLogActivityTimestamp = this.lastLogActivityTimestamp;
        this.logger.log(message, this.endpoint.getTransferLoggingLevel());
    }

    protected void doLogVerbose(String message) {
        this.lastVerboseLogActivity = message;
        this.lastVerboseLogActivityTimestamp = System.currentTimeMillis();
        if (this.endpoint.isTransferLoggingVerbose()) {
            this.logger.log(message, this.endpoint.getTransferLoggingLevel());
        }
    }
}

