/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.util.Map;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileExist;
import org.apache.camel.component.file.GenericFilePollingConsumer;
import org.apache.camel.component.file.GenericFileProducer;
import org.apache.camel.component.file.remote.RemoteFileComponent;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.component.file.remote.RemoteFileConsumer;
import org.apache.camel.component.file.remote.RemoteFileOperations;
import org.apache.camel.component.file.remote.RemoteFilePollingConsumerPollStrategy;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.processor.idempotent.MemoryIdempotentRepository;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RemoteFileEndpoint<T>
extends GenericFileEndpoint<T>
implements EndpointServiceLocation {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteFileEndpoint.class);
    @UriParam(label="advanced", description="Specifies the maximum reconnect attempts Camel performs when it tries to connect to the remote FTP server. Use 0 to disable this behavior.")
    private int maximumReconnectAttempts = 3;
    @UriParam(label="advanced", defaultValue="1000", description="Delay in millis Camel will wait before performing a reconnect attempt.", javaType="java.time.Duration")
    private long reconnectDelay = 1000L;
    @UriParam(label="common", description="Whether or not to disconnect from remote FTP server right after use. Disconnect will only disconnect the current connection to the FTP server. If you have a consumer which you want to stop, then you need to stop the consumer/route instead.")
    private boolean disconnect;
    @UriParam(label="producer,advanced", description="Whether or not to disconnect from remote FTP server right after a Batch upload is complete. disconnectOnBatchComplete will only disconnect the current connection to the FTP server.")
    private boolean disconnectOnBatchComplete;
    @UriParam(label="common,advanced", description="If set this option to be true, camel-ftp will use the list file directly to check if the file exists. Since some FTP server may not support to list the file directly, if the option is false, camel-ftp will use the old way to list the directory and check if the file exists. This option also influences readLock=changed to control whether it performs a fast check to update file information or not. This can be used to speed up the process if the FTP server has a lot of files.")
    private boolean fastExistsCheck;
    @UriParam(label="consumer,advanced", description="Whether the FTP consumer should download the file. If this option is set to false, then the message body will be null, but the consumer will still trigger a Camel Exchange that has details about the file such as file name, file size, etc. It's just that the file will not be downloaded.")
    private boolean download = true;

    protected RemoteFileEndpoint() {
        this.setSynchronous(true);
        this.setReadLockTimeout(20000L);
        this.setReadLockCheckInterval(5000L);
        this.setPollStrategy((PollingConsumerPollStrategy)new RemoteFilePollingConsumerPollStrategy());
    }

    protected RemoteFileEndpoint(String uri, RemoteFileComponent<T> component, RemoteFileConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
        this.setSynchronous(true);
        this.setReadLockTimeout(20000L);
        this.setReadLockCheckInterval(5000L);
        this.setPollStrategy((PollingConsumerPollStrategy)new RemoteFilePollingConsumerPollStrategy());
    }

    public boolean isSingletonProducer() {
        return false;
    }

    public RemoteFileConfiguration getConfiguration() {
        return (RemoteFileConfiguration)this.configuration;
    }

    public String getServiceUrl() {
        return this.getConfiguration().getProtocol() + ":" + this.getConfiguration().getHost() + ":" + this.getConfiguration().getPort();
    }

    public String getServiceProtocol() {
        return this.getConfiguration().getProtocol();
    }

    public Map<String, String> getServiceMetadata() {
        if (this.getConfiguration().getUsername() != null) {
            return Map.of("username", this.getConfiguration().getUsername());
        }
        return null;
    }

    public Exchange createExchange(GenericFile<T> file) {
        Exchange answer = super.createExchange();
        if (file != null) {
            file.bindToExchange(answer);
        }
        return answer;
    }

    public GenericFileProducer<T> createProducer() throws Exception {
        this.afterPropertiesSet();
        if (this.getFileExist() == GenericFileExist.Append && (this.getTempPrefix() != null || this.getTempFileName() != null)) {
            throw new IllegalArgumentException("You cannot set both fileExist=Append and tempPrefix/tempFileName options");
        }
        if (this.getFileExist() == GenericFileExist.Move && this.getMoveExisting() == null) {
            throw new IllegalArgumentException("You must configure moveExisting option when fileExist=Move");
        }
        if (this.getMoveExisting() != null && this.getFileExist() != GenericFileExist.Move) {
            throw new IllegalArgumentException("You must configure fileExist=Move when moveExisting has been set");
        }
        return this.buildProducer();
    }

    public RemoteFileConsumer<T> createConsumer(Processor processor) throws Exception {
        this.afterPropertiesSet();
        RemoteFileConsumer<T> consumer = this.buildConsumer(processor);
        if (this.isDelete() && this.getMove() != null) {
            throw new IllegalArgumentException("You cannot both set delete=true and move options");
        }
        if (this.isNoop() && !this.isIdempotentSet()) {
            LOG.info("Endpoint is configured with noop=true so forcing endpoint to be idempotent as well");
            this.setIdempotent(true);
        }
        if (this.isIdempotentSet() && Boolean.TRUE.equals(this.isIdempotent()) && this.idempotentRepository == null) {
            LOG.info("Using default memory based idempotent repository with cache max size: {}", (Object)1000);
            this.idempotentRepository = MemoryIdempotentRepository.memoryIdempotentRepository((int)1000);
        }
        if (!this.getConfiguration().isUseList() && this.getFileName() == null) {
            throw new IllegalArgumentException("Endpoint is configured with useList=false, then fileName must be configured also");
        }
        consumer.setMaxMessagesPerPoll(this.getMaxMessagesPerPoll());
        consumer.setEagerLimitMaxMessagesPerPoll(this.isEagerMaxMessagesPerPoll());
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public PollingConsumer createPollingConsumer() throws Exception {
        if (this.maxMessagesPerPoll > 1) {
            throw new IllegalArgumentException("The option maxMessagesPerPoll is not supported for polling consumer (such as when using poll or pollEnrich EIP)");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating GenericFilePollingConsumer with queueSize: {} blockWhenFull: {} blockTimeout: {}", new Object[]{this.getPollingConsumerQueueSize(), this.isPollingConsumerBlockWhenFull(), this.getPollingConsumerBlockTimeout()});
        }
        GenericFilePollingConsumer result = new GenericFilePollingConsumer((GenericFileEndpoint)this);
        result.setBlockWhenFull(this.isPollingConsumerBlockWhenFull());
        result.setBlockTimeout(this.getPollingConsumerBlockTimeout());
        return result;
    }

    protected void afterPropertiesSet() {
        RemoteFileConfiguration config = this.getConfiguration();
        StringHelper.notEmpty((String)config.getHost(), (String)"host");
        StringHelper.notEmpty((String)config.getProtocol(), (String)"protocol");
        if (!this.isSynchronous()) {
            throw new IllegalArgumentException("Using synchronous=false is not supported for camel-ftp");
        }
    }

    protected Map<String, Object> getParamsAsMap() {
        Map map = super.getParamsAsMap();
        map.put("fastExistsCheck", this.fastExistsCheck);
        return map;
    }

    protected abstract RemoteFileConsumer<T> buildConsumer(Processor var1);

    protected abstract GenericFileProducer<T> buildProducer();

    public abstract RemoteFileOperations<T> createRemoteFileOperations() throws Exception;

    public String remoteServerInformation() {
        return ((RemoteFileConfiguration)this.configuration).remoteServerInformation();
    }

    public char getFileSeparator() {
        return '/';
    }

    public boolean isAbsolute(String name) {
        return name.startsWith("/");
    }

    public int getMaximumReconnectAttempts() {
        return this.maximumReconnectAttempts;
    }

    public void setMaximumReconnectAttempts(int maximumReconnectAttempts) {
        this.maximumReconnectAttempts = maximumReconnectAttempts;
    }

    public long getReconnectDelay() {
        return this.reconnectDelay;
    }

    public void setReconnectDelay(long reconnectDelay) {
        this.reconnectDelay = reconnectDelay;
    }

    public boolean isDisconnect() {
        return this.disconnect;
    }

    public void setDisconnect(boolean disconnect) {
        this.disconnect = disconnect;
    }

    public boolean isDisconnectOnBatchComplete() {
        return this.disconnectOnBatchComplete;
    }

    public void setDisconnectOnBatchComplete(boolean disconnectOnBatchComplete) {
        this.disconnectOnBatchComplete = disconnectOnBatchComplete;
    }

    public boolean isFastExistsCheck() {
        return this.fastExistsCheck;
    }

    public void setFastExistsCheck(boolean fastExistsCheck) {
        this.fastExistsCheck = fastExistsCheck;
    }

    public boolean isDownload() {
        return this.download;
    }

    public void setDownload(boolean download) {
        this.download = download;
    }
}

