/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.UserInfo;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileExchange;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.component.file.remote.RemoteFileOperations;
import org.apache.camel.component.file.remote.SftpConfiguration;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SftpOperations
implements RemoteFileOperations<ChannelSftp.LsEntry> {
    private static final transient Log LOG = LogFactory.getLog(SftpOperations.class);
    private GenericFileEndpoint endpoint;
    private ChannelSftp channel;
    private Session session;

    public void setEndpoint(GenericFileEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public boolean connect(RemoteFileConfiguration configuration) throws GenericFileOperationFailedException {
        try {
            if (this.isConnected()) {
                return true;
            }
            if (this.channel == null || !this.channel.isConnected()) {
                if (this.session == null || !this.session.isConnected()) {
                    LOG.trace((Object)"Session isn't connected, trying to recreate and connect.");
                    this.session = this.createSession(configuration);
                    this.session.connect();
                }
                LOG.trace((Object)"Channel isn't connected, trying to recreate and connect.");
                this.channel = (ChannelSftp)this.session.openChannel("sftp");
                this.channel.connect();
                LOG.info((Object)("Connected to " + configuration.remoteServerInformation()));
            }
            return true;
        }
        catch (JSchException e) {
            throw new GenericFileOperationFailedException("Cannot connect to " + configuration.remoteServerInformation(), (Throwable)e);
        }
    }

    protected Session createSession(final RemoteFileConfiguration configuration) throws JSchException {
        JSch jsch = new JSch();
        SftpConfiguration sftpConfig = (SftpConfiguration)configuration;
        if (ObjectHelper.isNotEmpty((Object)sftpConfig.getPrivateKeyFile())) {
            LOG.debug((Object)("Using private keyfile: " + sftpConfig.getPrivateKeyFile()));
            if (ObjectHelper.isNotEmpty((Object)sftpConfig.getPrivateKeyFilePassphrase())) {
                jsch.addIdentity(sftpConfig.getPrivateKeyFile(), sftpConfig.getPrivateKeyFilePassphrase());
            } else {
                jsch.addIdentity(sftpConfig.getPrivateKeyFile());
            }
        }
        if (ObjectHelper.isNotEmpty((Object)sftpConfig.getKnownHostsFile())) {
            LOG.debug((Object)("Using knownhosts file: " + sftpConfig.getKnownHostsFile()));
            jsch.setKnownHosts(sftpConfig.getKnownHostsFile());
        }
        Session session = jsch.getSession(configuration.getUsername(), configuration.getHost(), configuration.getPort());
        session.setUserInfo(new UserInfo(){

            public String getPassphrase() {
                return null;
            }

            public String getPassword() {
                return configuration.getPassword();
            }

            public boolean promptPassword(String s) {
                return true;
            }

            public boolean promptPassphrase(String s) {
                return true;
            }

            public boolean promptYesNo(String s) {
                LOG.error((Object)s);
                return false;
            }

            public void showMessage(String s) {
            }
        });
        return session;
    }

    @Override
    public boolean isConnected() throws GenericFileOperationFailedException {
        return this.session != null && this.session.isConnected() && this.channel != null && this.channel.isConnected();
    }

    @Override
    public void disconnect() throws GenericFileOperationFailedException {
        if (this.session != null && this.session.isConnected()) {
            this.session.disconnect();
        }
        if (this.channel != null && this.channel.isConnected()) {
            this.channel.disconnect();
        }
    }

    public boolean deleteFile(String name) throws GenericFileOperationFailedException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Deleteing file: " + name));
        }
        try {
            this.channel.rm(name);
            return true;
        }
        catch (SftpException e) {
            throw new GenericFileOperationFailedException("Cannot delete file: " + name, (Throwable)e);
        }
    }

    public boolean renameFile(String from, String to) throws GenericFileOperationFailedException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Renaming file: " + from + " to: " + to));
        }
        try {
            this.channel.rename(from, to);
            return true;
        }
        catch (SftpException e) {
            throw new GenericFileOperationFailedException("Cannot rename file from: " + from + " to: " + to, (Throwable)e);
        }
    }

    public boolean buildDirectory(String directory, boolean absolute) throws GenericFileOperationFailedException {
        boolean success = false;
        String originalDirectory = this.getCurrentDirectory();
        try {
            try {
                this.channel.cd(directory);
                success = true;
            }
            catch (SftpException e) {
                // empty catch block
            }
            if (!success) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Trying to build remote directory: " + directory));
                }
                try {
                    this.channel.mkdir(directory);
                    success = true;
                }
                catch (SftpException e) {
                    success = this.buildDirectoryChunks(directory);
                }
            }
        }
        catch (IOException e) {
            throw new GenericFileOperationFailedException("Cannot build directory: " + directory, (Throwable)e);
        }
        catch (SftpException e) {
            throw new GenericFileOperationFailedException("Cannot build directory: " + directory, (Throwable)e);
        }
        finally {
            if (originalDirectory != null) {
                this.changeCurrentDirectory(originalDirectory);
            }
        }
        return success;
    }

    private boolean buildDirectoryChunks(String dirName) throws IOException, SftpException {
        StringBuilder sb = new StringBuilder(dirName.length());
        String[] dirs = dirName.split("/|\\\\");
        boolean success = false;
        for (String dir : dirs) {
            sb.append(dir).append('/');
            String directory = sb.toString();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Trying to build remote directory by chunk: " + directory));
            }
            if (directory.equals("/")) continue;
            try {
                this.channel.mkdir(directory);
                success = true;
            }
            catch (SftpException e) {
                // empty catch block
            }
        }
        return success;
    }

    public String getCurrentDirectory() throws GenericFileOperationFailedException {
        try {
            return this.channel.pwd();
        }
        catch (SftpException e) {
            throw new GenericFileOperationFailedException("Cannot get current directory", (Throwable)e);
        }
    }

    public void changeCurrentDirectory(String path) throws GenericFileOperationFailedException {
        try {
            this.channel.cd(path);
        }
        catch (SftpException e) {
            throw new GenericFileOperationFailedException("Cannot change current directory to: " + path, (Throwable)e);
        }
    }

    public List<ChannelSftp.LsEntry> listFiles() throws GenericFileOperationFailedException {
        return this.listFiles(".");
    }

    public List<ChannelSftp.LsEntry> listFiles(String path) throws GenericFileOperationFailedException {
        if (ObjectHelper.isEmpty((Object)path)) {
            path = ".";
        }
        try {
            ArrayList<ChannelSftp.LsEntry> list = new ArrayList<ChannelSftp.LsEntry>();
            Vector files = this.channel.ls(path);
            for (Object file : files) {
                list.add((ChannelSftp.LsEntry)file);
            }
            return list;
        }
        catch (SftpException e) {
            throw new GenericFileOperationFailedException("Cannot list directory: " + path, (Throwable)e);
        }
    }

    public boolean retrieveFile(String name, GenericFileExchange<ChannelSftp.LsEntry> exchange) throws GenericFileOperationFailedException {
        if (ObjectHelper.isNotEmpty((Object)this.endpoint.getLocalWorkDirectory())) {
            return this.retrieveFileToFileInLocalWorkDirectory(name, exchange);
        }
        return this.retrieveFileToStreamInBody(name, exchange);
    }

    private boolean retrieveFileToStreamInBody(String name, GenericFileExchange<ChannelSftp.LsEntry> exchange) throws GenericFileOperationFailedException {
        try {
            GenericFile target = exchange.getGenericFile();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            target.setBody((Object)os);
            this.channel.get(name, (OutputStream)os);
            return true;
        }
        catch (SftpException e) {
            throw new GenericFileOperationFailedException("Cannot retrieve file: " + name, (Throwable)e);
        }
    }

    private boolean retrieveFileToFileInLocalWorkDirectory(String name, GenericFileExchange<ChannelSftp.LsEntry> exchange) throws GenericFileOperationFailedException {
        FileOutputStream os;
        File temp;
        File local = new File(this.endpoint.getLocalWorkDirectory());
        try {
            String relativeName = exchange.getGenericFile().getRelativeFilePath();
            temp = new File(local, relativeName + ".inprogress");
            local = new File(local, relativeName);
            local.mkdirs();
            if (temp.exists() && !temp.delete()) {
                throw new GenericFileOperationFailedException("Cannot delete existing local work file: " + temp);
            }
            if (local.exists() && !local.delete()) {
                throw new GenericFileOperationFailedException("Cannot delete existing local work file: " + local);
            }
            if (!temp.createNewFile()) {
                throw new GenericFileOperationFailedException("Cannot create new local work file: " + temp);
            }
            os = new FileOutputStream(temp);
            exchange.getIn().setHeader("CamelFileLocalWorkPath", (Object)local.getPath());
        }
        catch (Exception e) {
            throw new GenericFileOperationFailedException("Cannot create new local work file: " + local);
        }
        try {
            GenericFile target = exchange.getGenericFile();
            target.setBody((Object)local);
            this.channel.get(name, (OutputStream)os);
            if (!temp.renameTo(local)) {
                throw new GenericFileOperationFailedException("Cannot rename local work file from: " + temp + " to: " + local);
            }
        }
        catch (SftpException e) {
            throw new GenericFileOperationFailedException("Cannot retrieve file: " + name, (Throwable)e);
        }
        finally {
            ObjectHelper.close((Closeable)os, (String)("retrieve: " + name), (Log)LOG);
        }
        return true;
    }

    public boolean storeFile(String name, GenericFileExchange<ChannelSftp.LsEntry> exchange) throws GenericFileOperationFailedException {
        try {
            InputStream in = (InputStream)ExchangeHelper.getMandatoryInBody(exchange, InputStream.class);
            this.channel.put(in, name);
            return true;
        }
        catch (SftpException e) {
            throw new GenericFileOperationFailedException("Cannot store file: " + name, (Throwable)e);
        }
        catch (InvalidPayloadException e) {
            throw new GenericFileOperationFailedException("Cannot store file: " + name, (Throwable)e);
        }
    }
}

