/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileExchange;
import org.apache.camel.component.file.GenericFileProducer;
import org.apache.camel.component.file.remote.RemoteFile;
import org.apache.camel.component.file.remote.RemoteFileComponent;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.component.file.remote.RemoteFileConsumer;
import org.apache.camel.component.file.remote.RemoteFileExchange;
import org.apache.camel.component.file.remote.RemoteFileOperations;
import org.apache.camel.component.file.remote.RemoteFileProducer;
import org.apache.camel.processor.idempotent.MemoryIdempotentRepository;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RemoteFileEndpoint<T>
extends GenericFileEndpoint<T> {
    public RemoteFileEndpoint() {
    }

    public RemoteFileEndpoint(String uri, RemoteFileComponent<T> component, RemoteFileOperations<T> operations, RemoteFileConfiguration configuration) {
        super(uri, component);
        this.operations = operations;
        this.configuration = configuration;
    }

    public GenericFileExchange createExchange() {
        return new RemoteFileExchange((Endpoint)this, this.getExchangePattern());
    }

    public GenericFileExchange<T> createExchange(GenericFile<T> file) {
        return new RemoteFileExchange(this, this.getExchangePattern(), (RemoteFile)file);
    }

    public GenericFileProducer<T> createProducer() throws Exception {
        this.afterPropertiesSet();
        return new RemoteFileProducer(this, (RemoteFileOperations)this.operations);
    }

    public RemoteFileConsumer<T> createConsumer(Processor processor) throws Exception {
        this.afterPropertiesSet();
        RemoteFileConsumer<T> consumer = this.buildConsumer(processor, (RemoteFileOperations)this.operations);
        if (this.configuration.getDirectory().contains(".")) {
            throw new IllegalArgumentException("Only directory is supported. Endpoint must be configured with a valid directory: " + this.configuration.getDirectory());
        }
        if (this.isDelete() && this.getMove() != null) {
            throw new IllegalArgumentException("You cannot both set delete=true and move options");
        }
        if (this.isNoop() && !this.isIdempotent()) {
            this.log.info((Object)"Endpoint is configured with noop=true so forcing endpoint to be idempotent as well");
            this.setIdempotent(true);
        }
        if (this.isIdempotent() && this.idempotentRepository == null) {
            this.log.info((Object)"Using default memory based idempotent repository with cache max size: 1000");
            this.idempotentRepository = MemoryIdempotentRepository.memoryIdempotentRepository((int)1000);
        }
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    protected void afterPropertiesSet() throws Exception {
        ObjectHelper.notNull((Object)this.operations, (String)"operations");
        RemoteFileConfiguration config = (RemoteFileConfiguration)this.getConfiguration();
        ObjectHelper.notEmpty((String)config.getHost(), (String)"host");
        ObjectHelper.notEmpty((String)config.getProtocol(), (String)"protocol");
        if (config.getPort() <= 0) {
            throw new IllegalArgumentException("port is not assigned to a positive value");
        }
    }

    protected abstract RemoteFileConsumer<T> buildConsumer(Processor var1, RemoteFileOperations<T> var2);

    public String remoteServerInformation() {
        return ((RemoteFileConfiguration)this.configuration).remoteServerInformation();
    }

    public char getFileSeparator() {
        return '/';
    }

    public boolean isAbsolute(String name) {
        return name.startsWith("/");
    }
}

