/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileExchange;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.remote.FtpConfiguration;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.component.file.remote.RemoteFileOperations;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtpOperations
implements RemoteFileOperations<FTPFile> {
    private static final transient Log LOG = LogFactory.getLog(FtpOperations.class);
    private final FTPClient client;
    private GenericFileEndpoint endpoint;

    public FtpOperations() {
        this.client = new FTPClient();
    }

    public FtpOperations(FTPClient client) {
        this.client = client;
    }

    public void setEndpoint(GenericFileEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public boolean connect(RemoteFileConfiguration config) throws GenericFileOperationFailedException {
        String host = config.getHost();
        int port = config.getPort();
        String username = config.getUsername();
        FtpConfiguration ftpConfig = (FtpConfiguration)config;
        if (ftpConfig.getFtpClientConfig() != null) {
            LOG.trace((Object)("Configuring FTPClient with config: " + ftpConfig.getFtpClientConfig()));
            this.client.configure(ftpConfig.getFtpClientConfig());
        }
        LOG.trace((Object)("Connecting to " + config.remoteServerInformation()));
        try {
            this.client.connect(host, port);
        }
        catch (IOException e) {
            throw new GenericFileOperationFailedException(this.client.getReplyCode(), this.client.getReplyString(), e.getMessage(), (Throwable)e);
        }
        if (config.isPassiveMode()) {
            LOG.trace((Object)"Using passive mode connections");
            this.client.enterLocalPassiveMode();
        }
        try {
            boolean login;
            if (username != null) {
                LOG.trace((Object)("Attempting to login user: " + username));
                login = this.client.login(username, config.getPassword());
            } else {
                LOG.trace((Object)"Attempting to login anonymousl");
                login = this.client.login("anonymous", null);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("User " + (username != null ? username : "anonymous") + " logged in: " + login));
            }
            if (!login) {
                throw new GenericFileOperationFailedException(this.client.getReplyCode(), this.client.getReplyString());
            }
            this.client.setFileType(config.isBinary() ? 2 : 0);
        }
        catch (IOException e) {
            throw new GenericFileOperationFailedException(this.client.getReplyCode(), this.client.getReplyString(), e.getMessage(), (Throwable)e);
        }
        return true;
    }

    @Override
    public boolean isConnected() throws GenericFileOperationFailedException {
        return this.client.isConnected();
    }

    @Override
    public void disconnect() throws GenericFileOperationFailedException {
        try {
            this.client.disconnect();
        }
        catch (IOException e) {
            throw new GenericFileOperationFailedException(this.client.getReplyCode(), this.client.getReplyString(), e.getMessage(), (Throwable)e);
        }
    }

    public boolean deleteFile(String name) throws GenericFileOperationFailedException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Deleteing file: " + name));
        }
        try {
            return this.client.deleteFile(name);
        }
        catch (IOException e) {
            throw new GenericFileOperationFailedException(this.client.getReplyCode(), this.client.getReplyString(), e.getMessage(), (Throwable)e);
        }
    }

    public boolean renameFile(String from, String to) throws GenericFileOperationFailedException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Renaming file: " + from + " to: " + to));
        }
        try {
            return this.client.rename(from, to);
        }
        catch (IOException e) {
            throw new GenericFileOperationFailedException(this.client.getReplyCode(), this.client.getReplyString(), e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean buildDirectory(String directory, boolean absolute) throws GenericFileOperationFailedException {
        boolean bl;
        block10: {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Building directory: " + directory));
            }
            String originalDirectory = this.client.printWorkingDirectory();
            try {
                boolean success = this.client.changeWorkingDirectory(directory);
                if (!success) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Trying to build remote directory: " + directory));
                    }
                    if (!(success = this.client.makeDirectory(directory))) {
                        success = this.buildDirectoryChunks(directory);
                    }
                }
                bl = success;
                if (originalDirectory == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (originalDirectory != null) {
                        this.client.changeWorkingDirectory(originalDirectory);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new GenericFileOperationFailedException(this.client.getReplyCode(), this.client.getReplyString(), e.getMessage(), (Throwable)e);
                }
            }
            this.client.changeWorkingDirectory(originalDirectory);
        }
        return bl;
    }

    public boolean retrieveFile(String name, GenericFileExchange<FTPFile> exchange) throws GenericFileOperationFailedException {
        if (ObjectHelper.isNotEmpty((Object)this.endpoint.getLocalWorkDirectory())) {
            return this.retrieveFileToFileInLocalWorkDirectory(name, exchange);
        }
        return this.retrieveFileToStreamInBody(name, exchange);
    }

    private boolean retrieveFileToStreamInBody(String name, GenericFileExchange<FTPFile> exchange) throws GenericFileOperationFailedException {
        ByteArrayOutputStream os = null;
        try {
            os = new ByteArrayOutputStream();
            GenericFile target = exchange.getGenericFile();
            target.setBody((Object)os);
            boolean bl = this.client.retrieveFile(name, (OutputStream)os);
            return bl;
        }
        catch (IOException e) {
            throw new GenericFileOperationFailedException(this.client.getReplyCode(), this.client.getReplyString(), e.getMessage(), (Throwable)e);
        }
        finally {
            ObjectHelper.close((Closeable)os, (String)("retrieve: " + name), (Log)LOG);
        }
    }

    private boolean retrieveFileToFileInLocalWorkDirectory(String name, GenericFileExchange<FTPFile> exchange) throws GenericFileOperationFailedException {
        boolean result;
        FileOutputStream os;
        File temp;
        File local = new File(FileUtil.normalizePath((String)this.endpoint.getLocalWorkDirectory()));
        try {
            String relativeName = exchange.getGenericFile().getRelativeFilePath();
            temp = new File(local, relativeName + ".inprogress");
            local = new File(local, relativeName);
            local.mkdirs();
            if (temp.exists() && !temp.delete()) {
                throw new GenericFileOperationFailedException("Cannot delete existing local work file: " + temp);
            }
            if (local.exists() && !local.delete()) {
                throw new GenericFileOperationFailedException("Cannot delete existing local work file: " + local);
            }
            if (!temp.createNewFile()) {
                throw new GenericFileOperationFailedException("Cannot create new local work file: " + temp);
            }
            os = new FileOutputStream(temp);
            exchange.getIn().setHeader("CamelFileLocalWorkPath", (Object)local.getPath());
        }
        catch (Exception e) {
            throw new GenericFileOperationFailedException("Cannot create new local work file: " + local);
        }
        try {
            GenericFile target = exchange.getGenericFile();
            target.setBody((Object)local);
            result = this.client.retrieveFile(name, (OutputStream)os);
        }
        catch (IOException e) {
            throw new GenericFileOperationFailedException(this.client.getReplyCode(), this.client.getReplyString(), e.getMessage(), (Throwable)e);
        }
        finally {
            ObjectHelper.close((Closeable)os, (String)("retrieve: " + name), (Log)LOG);
        }
        if (!temp.renameTo(local)) {
            throw new GenericFileOperationFailedException("Cannot rename local work file from: " + temp + " to: " + local);
        }
        return result;
    }

    public boolean storeFile(String name, GenericFileExchange<FTPFile> exchange) throws GenericFileOperationFailedException {
        InputStream is = (InputStream)exchange.getIn().getBody(InputStream.class);
        try {
            boolean bl = this.client.storeFile(name, is);
            return bl;
        }
        catch (IOException e) {
            throw new GenericFileOperationFailedException(this.client.getReplyCode(), this.client.getReplyString(), e.getMessage(), (Throwable)e);
        }
        finally {
            ObjectHelper.close((Closeable)is, (String)("store: " + name), (Log)LOG);
        }
    }

    public String getCurrentDirectory() throws GenericFileOperationFailedException {
        try {
            return this.client.printWorkingDirectory();
        }
        catch (IOException e) {
            throw new GenericFileOperationFailedException(this.client.getReplyCode(), this.client.getReplyString(), e.getMessage(), (Throwable)e);
        }
    }

    public void changeCurrentDirectory(String newDirectory) throws GenericFileOperationFailedException {
        try {
            this.client.changeWorkingDirectory(newDirectory);
        }
        catch (IOException e) {
            throw new GenericFileOperationFailedException(this.client.getReplyCode(), this.client.getReplyString(), e.getMessage(), (Throwable)e);
        }
    }

    public List<FTPFile> listFiles() throws GenericFileOperationFailedException {
        return this.listFiles(".");
    }

    public List<FTPFile> listFiles(String path) throws GenericFileOperationFailedException {
        if (ObjectHelper.isEmpty((Object)path)) {
            path = ".";
        }
        try {
            ArrayList<FTPFile> list = new ArrayList<FTPFile>();
            FTPFile[] files = this.client.listFiles(path);
            list.addAll(Arrays.asList(files));
            return list;
        }
        catch (IOException e) {
            throw new GenericFileOperationFailedException(this.client.getReplyCode(), this.client.getReplyString(), e.getMessage(), (Throwable)e);
        }
    }

    private boolean buildDirectoryChunks(String dirName) throws IOException {
        StringBuilder sb = new StringBuilder(dirName.length());
        String[] dirs = dirName.split("/|\\\\");
        boolean success = false;
        for (String dir : dirs) {
            sb.append(dir).append('/');
            String directory = sb.toString();
            if (directory.equals("/")) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Trying to build remote directory by chunk: " + directory));
            }
            success = this.client.makeDirectory(directory);
        }
        return success;
    }
}

