/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.util.List;
import org.apache.camel.Processor;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.remote.RemoteFile;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.component.file.remote.RemoteFileConsumer;
import org.apache.camel.component.file.remote.RemoteFileEndpoint;
import org.apache.camel.component.file.remote.RemoteFileOperations;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.net.ftp.FTPFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtpConsumer
extends RemoteFileConsumer<FTPFile> {
    private String endpointPath;

    public FtpConsumer(RemoteFileEndpoint<FTPFile> endpoint, Processor processor, RemoteFileOperations<FTPFile> fileOperations) {
        super(endpoint, processor, fileOperations);
        this.endpointPath = endpoint.getConfiguration().getDirectory();
    }

    protected void pollDirectory(String fileName, List<GenericFile<FTPFile>> fileList) {
        if (fileName == null) {
            return;
        }
        fileName = FileUtil.stripTrailingSeparator((String)fileName);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Polling directory: " + fileName));
        }
        List files = this.operations.listFiles(fileName);
        for (FTPFile file : files) {
            RemoteFile<FTPFile> remote;
            if (file.isDirectory()) {
                remote = this.asRemoteFile(fileName, file);
                if (!this.endpoint.isRecursive() || !this.isValidFile(remote, true)) continue;
                String directory = fileName + "/" + file.getName();
                this.pollDirectory(directory, fileList);
                continue;
            }
            if (file.isFile()) {
                remote = this.asRemoteFile(fileName, file);
                if (!this.isValidFile(remote, false)) continue;
                fileList.add(remote);
                continue;
            }
            this.log.debug((Object)("Ignoring unsupported remote file type: " + file));
        }
    }

    private RemoteFile<FTPFile> asRemoteFile(String directory, FTPFile file) {
        RemoteFile<FTPFile> answer = new RemoteFile<FTPFile>();
        answer.setEndpointPath(this.endpointPath);
        answer.setFile(file);
        answer.setFileName(file.getName());
        answer.setFileNameOnly(file.getName());
        answer.setFileLength(file.getSize());
        if (file.getTimestamp() != null) {
            answer.setLastModified(file.getTimestamp().getTimeInMillis());
        }
        answer.setHostname(((RemoteFileConfiguration)this.endpoint.getConfiguration()).getHost());
        answer.setAbsolute(false);
        String absoluteFileName = (ObjectHelper.isNotEmpty((Object)directory) ? directory + "/" : "") + file.getName();
        answer.setAbsoluteFilePath(absoluteFileName);
        String relativePath = ObjectHelper.after((String)absoluteFileName, (String)this.endpointPath);
        relativePath = FileUtil.stripLeadingSeparator((String)relativePath);
        answer.setRelativeFilePath(relativePath);
        return answer;
    }
}

