/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpException;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SftpUtils {
    private static final transient Log LOG = LogFactory.getLog(SftpUtils.class);

    private SftpUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean buildDirectory(ChannelSftp sftpClient, String dirName) throws IOException, SftpException {
        String originalDirectory = sftpClient.pwd();
        boolean success = false;
        try {
            try {
                sftpClient.cd(dirName);
                success = true;
            }
            catch (SftpException e) {
                // empty catch block
            }
            if (!success) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Trying to build remote directory: " + dirName));
                }
                try {
                    sftpClient.mkdir(dirName);
                    success = true;
                }
                catch (SftpException e) {
                    success = SftpUtils.buildDirectoryChunks(sftpClient, dirName);
                }
            }
        }
        finally {
            sftpClient.cd(originalDirectory);
        }
        return success;
    }

    public static boolean buildDirectoryChunks(ChannelSftp sftpClient, String dirName) throws IOException, SftpException {
        StringBuilder sb = new StringBuilder(dirName.length());
        String[] dirs = dirName.split("\\/");
        boolean success = false;
        for (String dir : dirs) {
            sb.append(dir).append('/');
            String directory = sb.toString();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Trying to build remote directory: " + directory));
            }
            try {
                sftpClient.mkdir(directory);
                success = true;
            }
            catch (SftpException e) {
                // empty catch block
            }
        }
        return success;
    }
}

