/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.file.remote.RemoteFileEndpoint;
import org.apache.camel.component.file.remote.RemoteFileExchange;
import org.apache.camel.impl.ScheduledPollConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RemoteFileConsumer<T extends RemoteFileExchange>
extends ScheduledPollConsumer<T> {
    protected final transient Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected RemoteFileEndpoint<T> endpoint;
    protected long lastPollTime;
    protected boolean recursive;
    protected String regexPattern;
    protected boolean setNames = true;
    protected boolean exclusiveReadLock;
    protected boolean deleteFile;
    protected String moveNamePrefix;
    protected String moveNamePostfix;
    protected String excludedNamePrefix;
    protected String excludedNamePostfix;
    private boolean timestamp;

    public RemoteFileConsumer(RemoteFileEndpoint<T> endpoint, Processor processor) {
        super(endpoint, processor);
        this.endpoint = endpoint;
    }

    public RemoteFileConsumer(RemoteFileEndpoint<T> endpoint, Processor processor, ScheduledExecutorService executor) {
        super(endpoint, processor, executor);
    }

    protected abstract String getFileName(Object var1);

    protected boolean isMatched(Object file) {
        String name = this.getFileName(file);
        if (name.startsWith(".")) {
            return false;
        }
        if (this.regexPattern != null && this.regexPattern.length() > 0 && !name.matches(this.regexPattern)) {
            return false;
        }
        if (this.excludedNamePrefix != null && name.startsWith(this.excludedNamePrefix)) {
            return false;
        }
        return this.excludedNamePostfix == null || !name.endsWith(this.excludedNamePostfix);
    }

    protected boolean isMoveFile() {
        return this.moveNamePostfix != null || this.moveNamePrefix != null || this.endpoint.getConfiguration().getExpression() != null;
    }

    protected String getMoveFileName(String name, Exchange exchange) {
        if (this.endpoint.getConfiguration().getExpression() != null) {
            Object result = this.endpoint.getConfiguration().getExpression().evaluate(exchange);
            return (String)exchange.getContext().getTypeConverter().convertTo(String.class, result);
        }
        StringBuffer buffer = new StringBuffer();
        if (this.moveNamePrefix != null) {
            buffer.append(this.moveNamePrefix);
        }
        buffer.append(name);
        if (this.moveNamePostfix != null) {
            buffer.append(this.moveNamePostfix);
        }
        return buffer.toString();
    }

    protected String remoteServer() {
        return this.endpoint.getConfiguration().remoteServerInformation();
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public long getLastPollTime() {
        return this.lastPollTime;
    }

    public void setLastPollTime(long lastPollTime) {
        this.lastPollTime = lastPollTime;
    }

    public String getRegexPattern() {
        return this.regexPattern;
    }

    public void setRegexPattern(String regexPattern) {
        this.regexPattern = regexPattern;
    }

    public boolean isSetNames() {
        return this.setNames;
    }

    public void setSetNames(boolean setNames) {
        this.setNames = setNames;
    }

    public boolean isExclusiveReadLock() {
        return this.exclusiveReadLock;
    }

    public void setExclusiveReadLock(boolean exclusiveReadLock) {
        this.exclusiveReadLock = exclusiveReadLock;
    }

    public boolean isDeleteFile() {
        return this.deleteFile;
    }

    public void setDeleteFile(boolean deleteFile) {
        this.deleteFile = deleteFile;
    }

    public String getMoveNamePrefix() {
        return this.moveNamePrefix;
    }

    public void setMoveNamePrefix(String moveNamePrefix) {
        this.moveNamePrefix = moveNamePrefix;
    }

    public String getMoveNamePostfix() {
        return this.moveNamePostfix;
    }

    public void setMoveNamePostfix(String moveNamePostfix) {
        this.moveNamePostfix = moveNamePostfix;
    }

    public String getExcludedNamePrefix() {
        return this.excludedNamePrefix;
    }

    public void setExcludedNamePrefix(String excludedNamePrefix) {
        this.excludedNamePrefix = excludedNamePrefix;
    }

    public String getExcludedNamePostfix() {
        return this.excludedNamePostfix;
    }

    public void setExcludedNamePostfix(String excludedNamePostfix) {
        this.excludedNamePostfix = excludedNamePostfix;
    }

    public boolean isTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(boolean timestamp) {
        this.timestamp = timestamp;
    }
}

